package com.biz.crm.kms.business.grab.rule.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.grab.rule.local.entity.GrabRuleEntity;
import com.biz.crm.kms.business.grab.rule.local.model.GrabRuleConditionModel;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRulePageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 抓单规则表的mybatis-plus接口类 {@link GrabRuleEntity}
 *
 * @author ning.zhang
 * @date 2022-09-26 16:38:27
 */
public interface GrabRuleMapper extends BaseMapper<GrabRuleEntity> {

  /**
   * 多条件查询抓单规则列表
   *
   * @param model 条件model
   * @return 抓单规则列表
   */
  List<GrabRuleEntity> findByGrabRuleConditionModel(@Param("model") GrabRuleConditionModel model);

  /**
   * 抓单规则分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<SchemeEntity> 抓单规则分页信息
   */
  Page<GrabRuleEntity> findByConditions(Page<GrabRuleEntity> page, @Param("dto") GrabRulePageDto dto);
}

