package com.biz.crm.kms.business.grab.rule.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.Set;

/**
 * 抓单规则多条件model
 *
 * @author ning.zhang
 * @date 2022/9/26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "GrabRuleConditionModel", description = "抓单规则多条件model")
public class GrabRuleConditionModel {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  @ApiModelProperty("数据状态（删除状态）")
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @ApiModelProperty("数据业务状态（启用状态）")
  private String enableStatus;

  /**
   * 抓单规则ID集合
   */
  @ApiModelProperty("抓单规则ID集合")
  private Set<String> ids;

  /**
   * 获取自动抓单数据标识(Y:是,N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("获取自动抓单数据标识(Y:是,N:否)")
  private String autoGrabFlag;

  /**
   * 当前日期时间
   */
  @ApiModelProperty("当前日期时间")
  private Date nowDate;

  /**
   * 当前日期时间戳
   */
  @ApiModelProperty("当前日期时间戳")
  private Long nowTimestamp;

  /**
   * 当前时间(HH:MM)
   */
  @ApiModelProperty("当前时间(HH:MM)")
  private String nowTime;
}
