package com.biz.crm.kms.business.grab.rule.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.grab.rule.local.entity.GrabRequestEntity;
import com.biz.crm.kms.business.grab.rule.local.mapper.GrabRequestMapper;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRequestDto;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 抓单请求表的数据库访问类 {@link GrabRequestEntity}
 *
 * @author ning.zhang
 * @date 2022-09-27 14:29:47
 */
@Component
public class GrabRequestRepository extends ServiceImpl<GrabRequestMapper, GrabRequestEntity> {


  /**
   * 查询抓单请求数据列表
   *
   * @param dto 请求dto
   * @return 抓单请求数据列表
   */
  public List<GrabRequestEntity> findByGrabRequestDto(GrabRequestDto dto) {
    return this.baseMapper.findByGrabRequestDto(dto);
  }
}
