package com.biz.crm.kms.business.grab.rule.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.grab.rule.local.entity.GrabRuleEntity;
import com.biz.crm.kms.business.grab.rule.local.mapper.GrabRuleMapper;
import com.biz.crm.kms.business.grab.rule.local.model.GrabRuleConditionModel;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRulePageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 抓单规则表的数据库访问类 {@link GrabRuleEntity}
 *
 * @author ning.zhang
 * @date 2022-09-26 16:38:27
 */
@Component
public class GrabRuleRepository extends ServiceImpl<GrabRuleMapper, GrabRuleEntity> {

  /**
   * 多条件查询抓单规则列表
   *
   * @param model 条件model
   * @return 抓单规则列表
   */
  public List<GrabRuleEntity> findByGrabRuleConditionModel(GrabRuleConditionModel model) {
    return this.baseMapper.findByGrabRuleConditionModel(model);
  }
  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(GrabRuleEntity::getId, ids)
        .set(GrabRuleEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param ids          ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(GrabRuleEntity::getId, ids)
        .set(GrabRuleEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 抓单规则分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<GrabRuleEntity> 抓单规则分页信息
   */
  public Page<GrabRuleEntity> findByConditions(Pageable pageable, GrabRulePageDto dto) {
    Page<GrabRuleEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
