package com.biz.crm.kms.business.grab.rule.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.grab.rule.local.entity.GrabRuleStoreEntity;
import com.biz.crm.kms.business.grab.rule.local.mapper.GrabRuleStoreMapper;
import org.springframework.stereotype.Component;

/**
 * 抓单规则门店表的数据库访问类 {@link GrabRuleStoreEntity}
 *
 * @author ning.zhang
 * @date 2022-09-26 16:38:26
 */
@Component
public class GrabRuleStoreRepository extends ServiceImpl<GrabRuleStoreMapper, GrabRuleStoreEntity> {

  /**
   * 通过抓单规则ID删除抓单规则照片信息
   *
   * @param ruleId 抓单规则ID
   */
  public void deleteByRuleId(String ruleId) {
    this.lambdaUpdate()
        .eq(GrabRuleStoreEntity::getRuleId, ruleId)
        .remove();
  }
}
