package com.biz.crm.kms.business.grab.rule.local.service;

import com.biz.crm.kms.business.grab.rule.local.entity.GrabRuleEntity;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRuleDto;

import java.util.List;

/**
 * 抓单规则表服务接口
 *
 * @author ning.zhang
 * @date 2022-09-26 16:38:27
 */
public interface GrabRuleService {

  /**
   * 创建抓单规则
   *
   * @param dto 请求参数dto
   * @return 抓单规则实体
   */
  GrabRuleEntity create(GrabRuleDto dto);

  /**
   * 更新抓单规则
   *
   * @param dto 请求参数dto
   * @return 抓单规则实体
   */
  GrabRuleEntity update(GrabRuleDto dto);

  /**
   * 批量删除抓单规则
   *
   * @param ids 抓单规则id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用抓单规则
   *
   * @param ids 抓单规则id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用抓单规则
   *
   * @param ids 抓单规则id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 自动抓单定时任务
   */
  void executeTask();

  /**
   * 手动抓取
   *
   * @param dto 请求参数dto
   */
  void manualGrab(GrabRuleDto dto);
}
