package com.biz.crm.kms.business.grab.rule.local.service.internal;

import com.biz.crm.kms.business.grab.rule.local.entity.GrabRequestEntity;
import com.biz.crm.kms.business.grab.rule.local.repository.GrabRequestRepository;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRequestDto;
import com.biz.crm.kms.business.grab.rule.sdk.service.GrabRequestVoService;
import com.biz.crm.kms.business.grab.rule.sdk.vo.GrabRequestVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 抓单请求VO服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/10/24
 */
@Slf4j
@Service
public class GrabRequestVoServiceImpl implements GrabRequestVoService {

  @Autowired
  private GrabRequestRepository grabRequestRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<GrabRequestVo> findByGrabRequestDto(GrabRequestDto dto) {
    dto = ObjectUtils.defaultIfNull(dto, new GrabRequestDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    List<GrabRequestEntity> entities = this.grabRequestRepository.findByGrabRequestDto(dto);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    return (List<GrabRequestVo>) this.nebulaToolkitService.copyCollectionByBlankList(entities, GrabRequestEntity.class
        , GrabRequestVo.class, HashSet.class, ArrayList.class);
  }
}
