package com.biz.crm.kms.business.grab.rule.local.service.internal;

import com.biz.crm.kms.business.grab.rule.local.entity.GrabRuleEntity;
import com.biz.crm.kms.business.grab.rule.local.repository.GrabRuleStoreRepository;
import com.biz.crm.kms.business.grab.rule.local.service.GrabRuleStoreService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 抓单规则门店表服务实现类
 *
 * @author ning.zhang
 * @date 2022-09-26 16:38:26
 */
@Slf4j
@Service("grabRuleStoreService")
public class GrabRuleStoreServiceImpl implements GrabRuleStoreService {

  @Autowired
  private GrabRuleStoreRepository grabRuleStoreRepository;

  @Override
  @Transactional
  public void update(GrabRuleEntity ruleEntity) {
    Validate.notBlank(ruleEntity.getId(), "抓单规则ID不能为空");
    this.grabRuleStoreRepository.deleteByRuleId(ruleEntity.getId());
    if (CollectionUtils.isEmpty(ruleEntity.getStoreList())) {
      return;
    }
    this.updateValidation(ruleEntity);
    this.grabRuleStoreRepository.saveBatch(ruleEntity.getStoreList());
  }

  /**
   * 在修改GrabRuleStore模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param ruleEntity 检查对象
   */
  private void updateValidation(GrabRuleEntity ruleEntity) {
    ruleEntity.getStoreList().forEach(entity -> {
      Validate.notBlank(entity.getStoreCode(), "缺失门店编码");
      entity.setId(null);
      entity.setRuleId(ruleEntity.getId());
      entity.setStoreCode(entity.getStoreCode());
    });
  }
}
