/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.grab.rule.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.kms.business.grab.rule.local.entity.GrabRuleEntity;
import com.biz.crm.kms.business.grab.rule.local.model.GrabRuleConditionModel;
import com.biz.crm.kms.business.grab.rule.local.repository.GrabRuleRepository;
import com.biz.crm.kms.business.grab.rule.local.service.GrabRequestService;
import com.biz.crm.kms.business.grab.rule.local.service.GrabRuleService;
import com.biz.crm.kms.business.grab.rule.local.service.GrabRuleStoreService;
import com.biz.crm.kms.business.grab.rule.sdk.constant.GrabRuleConstant;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRuleDto;
import com.biz.crm.kms.business.grab.rule.sdk.enums.GrabType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="grabRuleService")
public class GrabRuleServiceImpl
implements GrabRuleService {
    private static final Logger log = LoggerFactory.getLogger(GrabRuleServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GrabRuleRepository grabRuleRepository;
    @Autowired
    private GrabRuleStoreService grabRuleStoreService;
    @Autowired
    private GrabRequestService grabRequestService;

    @Override
    @Transactional
    public GrabRuleEntity create(GrabRuleDto dto) {
        this.createValidation(dto);
        GrabRuleEntity entity = (GrabRuleEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, GrabRuleEntity.class, HashSet.class, ArrayList.class, new String[]{"ruleParam"}));
        entity.setRuleParam(JSON.toJSONString((Object)dto.getRuleParam()));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTaskTime(new Date());
        entity.setTaskTimestamp(entity.getTaskTime().getTime());
        this.grabRuleRepository.save((Object)entity);
        this.grabRuleStoreService.update(entity);
        return entity;
    }

    @Override
    @Transactional
    public GrabRuleEntity update(GrabRuleDto dto) {
        this.updateValidation(dto);
        GrabRuleConditionModel model = new GrabRuleConditionModel();
        model.setIds(Sets.newHashSet((Object[])new String[]{dto.getId()}));
        model.setTenantCode(dto.getTenantCode());
        List<GrabRuleEntity> entities = this.grabRuleRepository.findByGrabRuleConditionModel(model);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u6293\u5355\u89c4\u5219\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        GrabRuleEntity updateEntity = (GrabRuleEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, GrabRuleEntity.class, HashSet.class, ArrayList.class, new String[]{"ruleParam"}));
        updateEntity.setRuleParam(JSON.toJSONString((Object)dto.getRuleParam()));
        updateEntity.setTaskTime(new Date());
        updateEntity.setTaskTimestamp(updateEntity.getTaskTime().getTime());
        this.grabRuleRepository.updateById((Object)updateEntity);
        this.grabRuleStoreService.update(updateEntity);
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.grabRuleRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.grabRuleRepository.updateDelFlagByIds(ids);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        GrabRuleConditionModel model = new GrabRuleConditionModel();
        model.setIds(Sets.newHashSet(ids));
        model.setTenantCode(TenantUtils.getTenantCode());
        List<GrabRuleEntity> entities = this.grabRuleRepository.findByGrabRuleConditionModel(model);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.grabRuleRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        GrabRuleConditionModel model = new GrabRuleConditionModel();
        model.setIds(Sets.newHashSet(ids));
        model.setTenantCode(TenantUtils.getTenantCode());
        List<GrabRuleEntity> entities = this.grabRuleRepository.findByGrabRuleConditionModel(model);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.grabRuleRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @DynamicTaskService(cornExpression="0 0/10 * * * ?", taskDesc="\u81ea\u52a8\u6293\u5355\u5b9a\u65f6\u4efb\u52a1")
    @Transactional
    public void executeTask() {
        log.info("---------------------------------\u8fdb\u5165\u81ea\u52a8\u6293\u5355\u5b9a\u65f6\u4efb\u52a1---------------------------------");
        GrabRuleConditionModel model = new GrabRuleConditionModel();
        model.setTenantCode(TenantUtils.getTenantCode());
        model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        model.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        model.setAutoGrabFlag(BooleanEnum.TRUE.getCapital());
        model.setNowDate(new Date());
        model.setNowTimestamp(model.getNowDate().getTime());
        model.setNowTime(model.getNowDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().format(GrabRuleConstant.HH_MM));
        List<GrabRuleEntity> entities = this.grabRuleRepository.findByGrabRuleConditionModel(model);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        entities.forEach(ruleEntity -> ruleEntity.setGrabType(GrabType.AUTO.getDictCode()));
        this.grabRequestService.createBatch(entities);
        this.grabRuleRepository.updateBatchById(entities);
    }

    @Override
    @Transactional
    public void manualGrab(GrabRuleDto dto) {
        this.createToManualValidation(dto);
        GrabRuleEntity entity = (GrabRuleEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, GrabRuleEntity.class, HashSet.class, ArrayList.class, new String[]{"ruleParam"}));
        entity.setRuleParam(JSON.toJSONString((Object)dto.getRuleParam()));
        entity.setGrabType(GrabType.MANUAL.getDictCode());
        this.grabRequestService.createBatch(Lists.newArrayList((Object[])new GrabRuleEntity[]{entity}));
    }

    private void createValidation(GrabRuleDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getAccount(), (String)"\u7f3a\u5931\u5ba2\u6237\u8d26\u53f7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDirectCode(), (String)"\u7f3a\u5931\u7cfb\u7edf\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderType(), (String)"\u7f3a\u5931\u5355\u636e\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRuleName(), (String)"\u7f3a\u5931\u89c4\u5219\u540d\u79f0", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getRuleParam()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u89c4\u5219\u53c2\u6570", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStartTime(), (String)"\u7f3a\u5931\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getIntervalTime()) && dto.getIntervalTime() > 0 ? 1 : 0) != 0, (String)"\u65f6\u95f4\u95f4\u9694\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)String.format("%s:%s", dto.getEndTime(), "00")), (String)"\u975e\u6cd5\u7684\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm]", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)String.format("%s:%s", dto.getStartTime(), "00")), (String)"\u975e\u6cd5\u7684\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm]", (Object[])new Object[0]);
        Validate.isTrue((dto.getStartTime().compareTo(dto.getEndTime()) < 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u9700\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
    }

    private void updateValidation(GrabRuleDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAccount(), (String)"\u7f3a\u5931\u5ba2\u6237\u8d26\u53f7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDirectCode(), (String)"\u7f3a\u5931\u7cfb\u7edf\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderType(), (String)"\u7f3a\u5931\u5355\u636e\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRuleName(), (String)"\u7f3a\u5931\u89c4\u5219\u540d\u79f0", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getRuleParam()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u89c4\u5219\u53c2\u6570", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStartTime(), (String)"\u7f3a\u5931\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getIntervalTime()) && dto.getIntervalTime() > 0 ? 1 : 0) != 0, (String)"\u65f6\u95f4\u95f4\u9694\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)String.format("%s:%s", dto.getEndTime(), "00")), (String)"\u975e\u6cd5\u7684\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm]", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)String.format("%s:%s", dto.getStartTime(), "00")), (String)"\u975e\u6cd5\u7684\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm]", (Object[])new Object[0]);
        Validate.isTrue((dto.getStartTime().compareTo(dto.getEndTime()) < 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u9700\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
    }

    private void createToManualValidation(GrabRuleDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getAccount(), (String)"\u7f3a\u5931\u5ba2\u6237\u8d26\u53f7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDirectCode(), (String)"\u7f3a\u5931\u7cfb\u7edf\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderType(), (String)"\u7f3a\u5931\u5355\u636e\u7c7b\u578b", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getRuleParam()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u89c4\u5219\u53c2\u6570", (Object[])new Object[0]);
    }
}

