/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.grab.rule.local.service.internal;

import com.biz.crm.kms.business.grab.rule.local.entity.GrabRuleEntity;
import com.biz.crm.kms.business.grab.rule.local.repository.GrabRuleStoreRepository;
import com.biz.crm.kms.business.grab.rule.local.service.GrabRuleStoreService;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="grabRuleStoreService")
public class GrabRuleStoreServiceImpl
implements GrabRuleStoreService {
    private static final Logger log = LoggerFactory.getLogger(GrabRuleStoreServiceImpl.class);
    @Autowired
    private GrabRuleStoreRepository grabRuleStoreRepository;

    @Override
    @Transactional
    public void update(GrabRuleEntity ruleEntity) {
        Validate.notBlank((CharSequence)ruleEntity.getId(), (String)"\u6293\u5355\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.grabRuleStoreRepository.deleteByRuleId(ruleEntity.getId());
        if (CollectionUtils.isEmpty(ruleEntity.getStoreList())) {
            return;
        }
        this.updateValidation(ruleEntity);
        this.grabRuleStoreRepository.saveBatch(ruleEntity.getStoreList());
    }

    private void updateValidation(GrabRuleEntity ruleEntity) {
        ruleEntity.getStoreList().forEach(entity -> {
            Validate.notBlank((CharSequence)entity.getStoreCode(), (String)"\u7f3a\u5931\u95e8\u5e97\u7f16\u7801", (Object[])new Object[0]);
            entity.setId(null);
            entity.setRuleId(ruleEntity.getId());
            entity.setStoreCode(entity.getStoreCode());
        });
    }
}

