/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.grab.rule.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.grab.rule.local.entity.GrabRuleEntity;
import com.biz.crm.kms.business.grab.rule.local.model.GrabRuleConditionModel;
import com.biz.crm.kms.business.grab.rule.local.repository.GrabRuleRepository;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRulePageDto;
import com.biz.crm.kms.business.grab.rule.sdk.service.GrabRuleVoService;
import com.biz.crm.kms.business.grab.rule.sdk.vo.GrabRuleStoreVo;
import com.biz.crm.kms.business.grab.rule.sdk.vo.GrabRuleVo;
import com.biz.crm.kms.business.supermarket.store.sdk.service.SupermarketStoreVoService;
import com.biz.crm.kms.business.supermarket.store.sdk.vo.SupermarketStoreVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GrabRuleVoServiceImpl
implements GrabRuleVoService {
    private static final Logger log = LoggerFactory.getLogger(GrabRuleVoServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GrabRuleRepository grabRuleRepository;
    @Autowired
    private SupermarketStoreVoService supermarketStoreVoService;
    @Autowired
    private DirectVoService directVoService;

    public List<GrabRuleVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        GrabRuleConditionModel model = new GrabRuleConditionModel();
        model.setIds(ids);
        model.setTenantCode(TenantUtils.getTenantCode());
        model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<GrabRuleEntity> entities = this.grabRuleRepository.findByGrabRuleConditionModel(model);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        List<GrabRuleVo> list = entities.stream().map(ruleEntity -> {
            GrabRuleVo grabRuleVo = (GrabRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)ruleEntity, GrabRuleVo.class, HashSet.class, ArrayList.class, new String[]{"ruleParam"});
            grabRuleVo.setRuleParam(JSON.parseArray((String)ruleEntity.getRuleParam(), JSONObject.class));
            return grabRuleVo;
        }).collect(Collectors.toList());
        this.buildExtendInfo(list);
        return list;
    }

    public Page<GrabRuleVo> findByConditions(Pageable pageable, GrabRulePageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        dto = (GrabRulePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new GrabRulePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page<GrabRuleEntity> entityPage = this.grabRuleRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        List<GrabRuleVo> list = entityPage.getRecords().stream().map(ruleEntity -> {
            GrabRuleVo grabRuleVo = (GrabRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)ruleEntity, GrabRuleVo.class, HashSet.class, ArrayList.class, new String[]{"ruleParam"});
            grabRuleVo.setRuleParam(JSON.parseArray((String)ruleEntity.getRuleParam(), JSONObject.class));
            return grabRuleVo;
        }).collect(Collectors.toList());
        this.buildExtendInfo(list);
        pageResult.setRecords(list);
        return pageResult;
    }

    private void buildExtendInfo(List<GrabRuleVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        HashSet directCodes = Sets.newHashSet();
        HashSet storeCodes = Sets.newHashSet();
        list.forEach(grabRuleVo -> {
            directCodes.add(grabRuleVo.getDirectCode());
            storeCodes.addAll(grabRuleVo.getStoreList().stream().map(GrabRuleStoreVo::getStoreCode).collect(Collectors.toSet()));
        });
        List storeList = this.supermarketStoreVoService.findByStoreCodes((Set)storeCodes);
        HashMap storeMap = CollectionUtils.isEmpty((Collection)storeList) ? Maps.newHashMap() : storeList.stream().collect(Collectors.toMap(SupermarketStoreVo::getStoreCode, t -> t, (a, b) -> a));
        List directList = this.directVoService.findByDirectCodes((List)Lists.newArrayList((Iterable)directCodes));
        HashMap directMap = CollectionUtils.isEmpty((Collection)directList) ? Maps.newHashMap() : directList.stream().collect(Collectors.toMap(DirectVo::getDirectCode, t -> t, (a, b) -> a));
        list.forEach(grabRuleVo -> {
            DirectVo directVo = directMap.getOrDefault(grabRuleVo.getDirectCode(), new DirectVo());
            grabRuleVo.setRuleNameAccount(grabRuleVo.getRuleName() + "-" + grabRuleVo.getAccount());
            grabRuleVo.setDirectName(directVo.getSupermarketName());
            grabRuleVo.getStoreList().forEach(grabRuleStoreVo -> {
                SupermarketStoreVo supermarketStoreVo = storeMap.getOrDefault(grabRuleStoreVo.getStoreCode(), new SupermarketStoreVo());
                grabRuleStoreVo.setStoreName(supermarketStoreVo.getSupermarketName());
            });
        });
    }
}

