package com.biz.crm.kms.business.grab.rule.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.time.format.DateTimeFormatter;

/**
 * 抓单规则常量
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class GrabRuleConstant {

  /**
   * 请求参数字段设置（主体）
   */
  public static final String GRPC_REQ_BODY = "body";
  /**
   * 请求参数字段设置（扩展参数）
   */
  public static final String GRPC_REQ_EXTEND_ARGS = "extend_args";
  /**
   * 请求参数字段设置（请求体）
   */
  public static final String GRPC_REQ_REQ_PARAM = "req_parm";
  /**
   * 请求参数字段设置（请求体扩展字段）
   */
  public static final String GRPC_REQ_EXTEND_PARAM = "extend_parm";
  /**
   * 是否全部门店
   */
  public static final String KMS_ALL_STORE = "kms_all_store";
  /**
   * 门店编码
   */
  public static final String STORE_CODE = "code";
  /**
   * 门店名称
   */
  public static final String STORE_NAME = "name";
  /**
   * 抓单参数门店键
   */
  public static final String SOLD_TO_PARTY = "sold_to_party";
  /**
   * 商超名称
   */
  public static final String KA_NAME = "ka_name";
  /**
   * 抓单单据类型描述
   */
  public static final String DOC = "doc";
  /**
   * 登录用户名
   */
  public static final String USER_NAME = "username";
  /**
   * 登录密码
   */
  public static final String PASS_WORD = "password";
  /**
   * ka-flag
   */
  public static final String KMS_PATH_TYPE = "KMS_path_type";
  /**
   * ka-flag
   */
  public static final String KA_FLAG = "ka_flag";
  /**
   * kms-id
   */
  public static final String KMS_IP = "kms_ip";
  /**
   * 抓单规则创建人
   */
  public static final String PRINCIPAL_ID = "principal_id";
  /**
   * force'：'0' 表示会md5去重(自动抓单强制覆盖为md5去重)
   */
  public static final String FORCE = "force";
  /**
   * 租户ID
   */
  public static final String TENANTRY_ID = "tenantry_id";
  /**
   * 规则参数
   */
  public static final String RULE_PARAM = "rule_param";
  /**
   * 抓单规则名称
   */
  public static final String RULE_NAME = "rule_name";
  /**
   * 系统ID
   */
  public static final String DIRECT_SYSTEM_ID = "direct_system_id";
  /**
   * 单据类型ID
   */
  public static final String BS_INVOICE_ID = "bs_invoice_id";
  /**
   * track_id
   */
  public static final String TRACK_ID = "track_id";
  /**
   * 抓取类型 自动/手动
   */
  public static final String STYLE = "style";
  /**
   * 操作用户
   */
  public static final String NICK_NAME = "nick_name";
  /**
   * 抓取数据唯一ID
   */
  public static final String RESP_DATA_ID = "resp_data_id";
  /**
   * 文件名
   */
  public static final String FILE_NAMES = "file_names";
  /**
   * 文件类型
   */
  public static final String FILE_TYPE = "file_type";
  /**
   * 输入文件
   */
  public static final String INPUT_FILE = "input_file";
  /**
   * 应用ID
   */
  public static final String APP_ID = "app_id";
  /**
   * 时间日期格式yyyyMMddHHmmss
   */
  public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_NO_SPLIT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
  /**
   * 时间日期格式
   */
  public static final DateTimeFormatter HH_MM = DateTimeFormatter.ofPattern("HH:mm");
}
