package com.biz.crm.kms.business.grab.rule.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 抓单类型
 *
 * @author ning.zhang
 * @date 2022/9/27
 */
@Getter
@AllArgsConstructor
public enum GrabType {

  /**
   * 手动抓单
   */
  MANUAL("manual", "manual", "手动抓单", 0),

  /**
   * 自动抓单
   */
  AUTO("auto", "auto", "自动抓单", 1),

  /**
   * 手动导入
   */
  IMPORT("import", "import", "手动导入", 2),;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private Integer order;

  /**
   * 通过字典编码获取枚举值
   *
   * @param dictCode 字典编码
   * @return 取枚举值
   */
  public static GrabType getByDictCode(String dictCode) {
    GrabType result = null;
    for (GrabType type : GrabType.values()) {
      if (type.getDictCode().equals(dictCode)) {
        result = type;
        break;
      }
    }
    return result;
  }
}
