package com.biz.crm.kms.business.grab.rule.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRulePageDto;
import com.biz.crm.kms.business.grab.rule.sdk.vo.GrabRuleVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 抓单规则Vo服务接口类
 *
 * @author ning.zhang
 * @date 2022/9/26
 */
public interface GrabRuleVoService {

  /**
   * 通过抓单规则ID集合获取抓单规则信息
   *
   * @param ids 抓单规则ID集合
   * @return 抓单规则信息
   */
  List<GrabRuleVo> findByIds(Set<String> ids);

  /**
   * 根据参数分页查询抓单规则列表
   *
   * @param pageable        分页参数
   * @param dto 查询参数
   * @return 抓单规则列表
   */
  Page<GrabRuleVo> findByConditions(Pageable pageable, GrabRulePageDto dto);
}
