package com.biz.crm.kms.business.grab.rule.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 抓单请求VO
 *
 * @author ning.zhang
 * @date 2022/10/24
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "GrabRuleVo", description = "抓单请求VO")
public class GrabRequestVo extends UuidOpVo {

  private static final long serialVersionUID = 59929320472287679L;

  /**
   * 请求GRPC的信息
   */
  @ApiModelProperty("请求GRPC的信息")
  private String request;

  /**
   * 抓取发起时间
   */
  @ApiModelProperty("抓取发起时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date time;

  /**
   * 是否为自动抓单（1-自动抓单，0-手动抓单）
   */
  @ApiModelProperty("是否为自动抓单（1-自动抓单，0-手动抓单）")
  private Integer auto;

  /**
   * 失败次数
   */
  @ApiModelProperty("失败次数")
  private Integer fail;

  /**
   * 抓取的结果
   */
  @ApiModelProperty("抓取的结果")
  private String response;

  /**
   * 0-单线程，1-多线程
   */
  @ApiModelProperty("0-单线程，1-多线程")
  private Integer method;

  /**
   * 0-数据，1-文件
   */
  @ApiModelProperty("0-数据，1-文件")
  private Integer file;

  /**
   * UUID(PYTHON抓单需要字段)
   */
  @ApiModelProperty("UUID(PYTHON抓单需要字段)")
  private String uuid;
}
