package com.biz.crm.kms.business.grab.rule.sdk.vo;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 抓单规则Vo
 *
 * @author ning.zhang
 * @date 2022/9/26
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "GrabRuleVo", description = "抓单规则Vo")
public class GrabRuleVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 4283394901300305939L;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 系统名称
   */
  @ApiModelProperty("系统名称")
  private String directName;

  /**
   * 客户账号
   */
  @ApiModelProperty("客户账号")
  private String account;

  /**
   * 规则名称
   */
  @ApiModelProperty("规则名称")
  private String ruleName;

  /**
   * 规则名称
   */
  @ApiModelProperty("规则名称+客户账号")
  private String ruleNameAccount;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String orderType;

  /**
   * 开始时间(HH:MM)
   */
  @ApiModelProperty("开始时间(HH:MM)")
  private String startTime;

  /**
   * 结束时间(HH:MM)
   */
  @ApiModelProperty("结束时间(HH:MM)")
  private String endTime;

  /**
   * 时间间隔
   */
  @ApiModelProperty("时间间隔")
  private Integer intervalTime;

  /**
   * 是否是全部门店(Y:是,N:否)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否是全部门店(Y:是,N:否)")
  private String allStoreFlag;

  /**
   * 规则参数
   */
  @ApiModelProperty("规则参数")
  private List<JSONObject> ruleParam;

  /**
   * 门店列表
   */
  @ApiModelProperty("门店列表")
  private List<GrabRuleStoreVo> storeList;
}
