package com.biz.crm.kms.business.invoice.acceptance.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGrabService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.constant.AcceptanceOrderConstant;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Title: AcceptanceOrderConsumer
 * @Package: com.biz.crm.kms.business.invoice.acceptance.local.consumer
 * @Description:
 * @Author: cyj
 * @Date: 2022/11/24 - 18:47 PM
 */

@Slf4j
@Component
@RocketMQMessageListener(topic = AcceptanceOrderConstant.KMS_ACCEPTANCE_ORDER_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = AcceptanceOrderConstant.ACCEPTANCE_ORDER_MESSAGE_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = AcceptanceOrderConstant.ACCEPTANCE_ORDER_MESSAGE_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class AcceptanceOrderConsumer extends AbstractRocketMqConsumer {

    @Autowired
    private InvoiceAcceptanceGrabService invoiceAcceptanceGrabService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("验收单自动转换MQ接收成功;单号集合[{}]", message.getMsgBody());
        try {
            List<String> orderNumberList = JSON.parseArray(message.getMsgBody(), String.class);
            log.info("===== 自动转换开始 ======");
            this.invoiceAcceptanceGrabService.manualSwitch(orderNumberList);
            log.info("===== 自动转换完成 ======");
        } catch (Exception e) {
            log.error("", e);
        }
        return "消费成功";
    }
}
