package com.biz.crm.kms.business.invoice.acceptance.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGrabService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.service.InvoiceAcceptanceVoService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceVo;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * 验收单表(InvoiceAcceptance)表控制层
 *
 * @author pengxi
 * @date 2022/10/10
 */
@Slf4j
@Api(tags = "验收单表：InvoiceAcceptanceVo：验收单")
@RestController
@RequestMapping(value = {"/v1/invoiceAcceptance/invoiceAcceptanceVo"})
public class InvoiceAcceptanceVoController {

  @Autowired(required = false)
  private InvoiceAcceptanceVoService invoiceAcceptanceVoService;

  @Autowired(required = false)
  private InvoiceAcceptanceService invoiceAcceptanceService;

  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<InvoiceAcceptanceVo> findDetailById(@RequestParam("id") String id) {
    try {
      InvoiceAcceptanceVo vo = this.invoiceAcceptanceVoService.findDetailById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询结算单的验收单详情
   * @param code
   * @return
   */
  @ApiOperation(value = "查询结算单的验收单详情")
  @GetMapping(value = {"/findByDecomentCode"})
  public Result<InvoiceAcceptanceVo> findByDecomentCode(String code, String deliveryPartyCode){
    try {
      InvoiceAcceptanceVo vo = this.invoiceAcceptanceVoService.findByDecomentCode(code,deliveryPartyCode);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "手动转换")
  @PatchMapping(value = {"/manualSwitch"})
  public Result<?> manualSwitch(@RequestBody List<String> ids) {
    try {
      this.invoiceAcceptanceVoService.manualSwitch(ids);
      return Result.ok("转换结束");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @Autowired(required = false)
  private InvoiceAcceptanceGrabService invoiceAcceptanceGrabService;

  @ApiOperation("定时任务")
  @GetMapping()
  public void autoJob(){
    this.invoiceAcceptanceGrabService.autoNotConvertAcceptanceOrder();
  }

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "验收单删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.invoiceAcceptanceService.deleteByIds(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   * @param invoiceAcceptanceEntity
   * @return
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<InvoiceAcceptanceEntity> create(@ApiParam(name = "InvoiceAcceptanceEntity", value = "") @RequestBody InvoiceAcceptanceEntity invoiceAcceptanceEntity) {
    try {
      InvoiceAcceptanceEntity result = this.invoiceAcceptanceService.create(invoiceAcceptanceEntity);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 拆分验收单
   */
  @ApiOperation(value = "拆分验收单")
  @PostMapping("/splitAcceptance")
  public Result<?> splitAcceptance(@RequestBody List<InvoiceAcceptanceVo> invoiceAcceptanceVos){
    try {
      this.invoiceAcceptanceVoService.splitAcceptance(invoiceAcceptanceVos);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }



  /**
   * 撤销拆分验收单
   * @param id
   */
  @ApiOperation("撤销拆分验收单")
  @GetMapping("/withdrawSplit")
  public Result<?> withdrawSplit(String id){
    try {
      this.invoiceAcceptanceVoService.withdrawSplit(id);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }

  }

}
