package com.biz.crm.kms.business.invoice.acceptance.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceTestService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 验收单集合匹配测试(InvoiceAcceptance)表服务接口
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.13 15:10
 */
@Slf4j
@Api(tags = "验收单集合匹配测试")
@RestController
@RequestMapping(value = {"/v1/invoiceAcceptance/invoiceAcceptanceVoTest"})
public class InvoiceAcceptanceVoTestController {

    @Autowired(required = false)
    private InvoiceAcceptanceTestService invoiceAcceptanceTestService;

    /**
     * 禁用
     */
    @ApiOperation(value = "验收单稽核测试")
    @GetMapping("/auditTest")
    public Result auditTest() {
        invoiceAcceptanceTestService.auditTest();
        return Result.ok("验收单稽核测试");
    }
}
