package com.biz.crm.kms.business.invoice.acceptance.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 验收单（转换后）数据视图注册器
 *
 * @author pengxi
 * @date 2022/10/25
 */
@Component
public class InvoiceAcceptanceDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "kms_invoice_acceptance_data_view";
  }

  @Override
  public String desc() {
    return "KMS验收单（转换后）数据视图";
  }

  @Override
  public String buildSql() {
    return "SELECT kia.*,kd.sales_org_code " +
            "FROM kms_invoice_acceptance kia " +
            "LEFT JOIN kms_direct kd on kia.direct_code = kd.direct_code " +
            "WHERE kia.tenant_code = :tenantCode " +
            "AND kd.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
            "AND kia.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
  }
}
