package com.biz.crm.kms.business.invoice.acceptance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 验收单数据表(InvoiceAcceptance)实体类
 *
 * @author pengxi
 * @since 2022-10-12 18:13:33
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName(value = "kms_invoice_acceptance")
@Table(name = "kms_invoice_acceptance", indexes = {
    @Index(name = "ia_idx1", columnList = "tenant_code,order_number"),
    @Index(name = "ia_idx2", columnList = "tenant_code,ka_order_number"),
    @Index(name = "ia_idx3", columnList = "statement_code"),
    @Index(name = "ia_idx4", columnList = "direct_code"),
    @Index(name = "ia_idx5", columnList = "create_time"),
})
@ApiModel(value = "InvoiceAcceptanceEntity", description = "验收单数据表")
@org.hibernate.annotations.Table(appliesTo = "kms_invoice_acceptance", comment = "验收单数据表")
public class InvoiceAcceptanceEntity extends TenantFlagOpEntity {

  @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
  @TableField(value = "raw_data_id")
  @Column(name = "raw_data_id", length = 128, columnDefinition = "varchar(128) COMMENT '原始数据ID 对应表 kms_grab_response_data 的ID'")
  private String rawDataId;

  @ApiModelProperty("稽核日期")
  @TableField(value = "audit_date")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "audit_date" , length = 20, columnDefinition = "datetime COMMENT '稽核日期'")
  private Date auditDate;

  /**
   * [数据字典:mdm_business_format]
   */
  @ApiModelProperty("业态")
  @TableField(value = "business_format_code")
  @Column(name = "business_format_code", length = 64, columnDefinition = "varchar(64) COMMENT '业态'")
  private String businessFormatCode;

  /**
   * [数据字典:mdm_business_unit]
   */
  @ApiModelProperty("业务单元编码")
  @TableField(value = "business_unit_code")
  @Column(name = "business_unit_code", length = 64, columnDefinition = "varchar(64) COMMENT '业务单元编码'")
  private String businessUnitCode;

  @ApiModelProperty("售达方名称")
  @TableField(value = "sold_to_party_name")
  @Column(name = "sold_to_party_name", length = 256, columnDefinition = "varchar(256) COMMENT '售达方名称'")
  private String soldToPartyName;

  @ApiModelProperty("售达方编码")
  @TableField(value = "sold_to_party_code")
  @Column(name = "sold_to_party_code", length = 64, columnDefinition = "varchar(64) COMMENT '售达方编码'")
  private String soldToPartyCode;

  @ApiModelProperty("企业门店/大仓编号")
  @TableField(value = "store_code")
  @Column(name = "store_code", length = 64, columnDefinition = "varchar(64) COMMENT '企业门店/大仓编号'")
  private String storeCode;

  @ApiModelProperty("企业门店/大仓名称")
  @TableField(value = "store_name")
  @Column(name = "store_name", length = 256, columnDefinition = "varchar(256) COMMENT '企业门店/大仓名称'")
  private String storeName;

  @ApiModelProperty("送达方编码")
  @TableField(value = "delivery_party_code")
  @Column(name = "delivery_party_code", length = 32, columnDefinition = "varchar(32) COMMENT '送达方编码'")
  private String deliveryPartyCode;

  @ApiModelProperty("送达方名称")
  @TableField(value = "delivery_party_name")
  @Column(name = "delivery_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '送达方名称'")
  private String deliveryPartyName;

  @ApiModelProperty("关联结算单号")
  @Column(name = "statement_code",length = 32,columnDefinition = "varchar(32) COMMENT  '关联结算单号'")
  private String statementCode;


  @ApiModelProperty("转换状态")
  @TableField(value = "order_status")
  @Column(name = "order_status", length = 32, columnDefinition = "varchar(32) COMMENT '转换状态'")
  private String orderStatus;

  @ApiModelProperty("转换状态描述")
  @TableField(value = "order_status_msg")
  @Column(name = "order_status_msg", length = 128, columnDefinition = "varchar(128) COMMENT '转换状态描述'")
  private String orderStatusMsg;

  @ApiModelProperty("系统编码")
  @TableField(value = "direct_code")
  @Column(name = "direct_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统编码'")
  private String directCode;

  @ApiModelProperty("系统名称")
  @TableField(value = "direct_name")
  @Column(name = "direct_name", length = 64, columnDefinition = "varchar(32) COMMENT '系统名称'")
  private String directName;

  @ApiModelProperty("关联企业订货单编号")
  @TableField(value = "relate_order_number")
  @Column(name = "relate_order_number", length = 64, columnDefinition = "varchar(64) COMMENT '关联企业订货单编号'")
  private String relateOrderNumber;

  @ApiModelProperty("关联商超订货单编号")
  @TableField(value = "relate_ka_order_number")
  @Column(name = "relate_ka_order_number", length = 64, columnDefinition = "varchar(64) COMMENT '关联商超订货单编号'")
  private String relateKaOrderNumber;

  @ApiModelProperty("企业验收单编号")
  @TableField(value = "order_number")
  @Column(name = "order_number", length = 64, columnDefinition = "varchar(64) COMMENT '企业验收单编号'")
  private String orderNumber;

  @ApiModelProperty("商超验收单编号")
  @TableField(value = "ka_order_number")
  @Column(name = "ka_order_number", length = 64, columnDefinition = "varchar(64) COMMENT '商超验收单编号'")
  private String kaOrderNumber;

  @ApiModelProperty("验收日期")
  @TableField(value = "acceptance_date")
  @Column(name = "acceptance_date" , length = 32, columnDefinition = "varchar(32) COMMENT '验收日期'")
  private String acceptanceDate;

  @ApiModelProperty("验收日期(页面用)")
  @TableField(value = "acceptance_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "acceptance_time" , length = 20, columnDefinition = "datetime COMMENT '验收日期(页面用)'")
  private Date acceptanceTime;

  @ApiModelProperty("验收类型")
  @TableField(value = "acceptance_type")
  @Column(name = "acceptance_type", length = 64, columnDefinition = "varchar(64) COMMENT '验收类型'")
  private String acceptanceType;

  @ApiModelProperty("单据来源")
  @TableField(value = "invoices_source")
  @Column(name = "invoices_source", length = 64, columnDefinition = "varchar(64) COMMENT '单据来源'")
  private String invoicesSource;

  @ApiModelProperty("商超编码")
  @TableField(value = "ka_code")
  @Column(name = "ka_code", length = 64, columnDefinition = "varchar(64) COMMENT '商超编码'")
  private String kaCode;

  @ApiModelProperty("商超名称")
  @TableField(value = "ka_name")
  @Column(name = "ka_name", length = 256, columnDefinition = "varchar(256) COMMENT '商超名称'")
  private String kaName;

  @ApiModelProperty("商超门店/大仓编号")
  @TableField(value = "ka_store_code")
  @Column(name = "ka_store_code", length = 64, columnDefinition = "varchar(64) COMMENT '商超门店/大仓编号'")
  private String kaStoreCode;

  @ApiModelProperty("商超门店/大仓名称")
  @TableField(value = "ka_store_name")
  @Column(name = "ka_store_name", length = 256, columnDefinition = "varchar(256) COMMENT '商超门店/大仓名称'")
  private String kaStoreName;

  @ApiModelProperty("订货单总金额（含税）")
  @TableField(value = "final_order_amount")
  @Column(name = "final_order_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '订货单总金额（含税）'")
  private BigDecimal finalOrderAmount;

  @ApiModelProperty("订货单总金额（不含税）")
  @TableField(value = "final_order_amount_not")
  @Column(name = "final_order_amount_not", length = 20, columnDefinition = "decimal(20,4) COMMENT '订货单总金额（不含税）'")
  private BigDecimal finalOrderAmountNot;

  @ApiModelProperty("验收单总金额（含税）")
  @TableField(value = "final_acceptance_amount")
  @Column(name = "final_acceptance_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '验收单总金额（含税）'")
  private BigDecimal finalAcceptanceAmount;

  @ApiModelProperty("验收单总金额（不含税）")
  @TableField(value = "final_acceptance_amount_not")
  @Column(name = "final_acceptance_amount_not", length = 20, columnDefinition = "decimal(20,4) COMMENT '验收单总金额（不含税）'")
  private BigDecimal finalAcceptanceAmountNot;

  @ApiModelProperty("业务区域负责人")
  @TableField(value = "business_area_leader")
  @Column(name = "business_area_leader", length = 64, columnDefinition = "varchar(64) COMMENT '业务区域负责人'")
  private String businessAreaLeader;

  @ApiModelProperty("业务区域")
  @TableField(value = "business_area")
  @Column(name = "business_area", length = 64, columnDefinition = "varchar(64) COMMENT '业务区域'")
  private String businessArea;

  @ApiModelProperty("区域编码")
  @TableField(value = "area_code")
  @Column(name = "area_code", length = 64, columnDefinition = "varchar(64) COMMENT '区域编码'")
  private String areaCode;

  @ApiModelProperty("区域名称")
  @TableField(value = "area_name")
  @Column(name = "area_name", length = 256, columnDefinition = "varchar(256) COMMENT '区域名称'")
  private String areaName;

  @ApiModelProperty("登录账号")
  @TableField(value = "user_name")
  @Column(name = "user_name", length = 64, columnDefinition = "varchar(64) COMMENT '登录账号'")
  private String userName;

  @ApiModelProperty("供应商名称")
  @TableField(value = "supplier_name")
  @Column(name = "supplier_name", length = 256, columnDefinition = "varchar(256) COMMENT '供应商名称'")
  private String supplierName;

  @ApiModelProperty("供应商编码")
  @TableField(value = "supplier_code")
  @Column(name = "supplier_code", length = 64, columnDefinition = "varchar(64) COMMENT '供应商编码'")
  private String supplierCode;

  @ApiModelProperty("单据版本号")
  @TableField(value = "version_number")
  @Column(name = "version_number", length = -1, columnDefinition = "int COMMENT '单据版本号'")
  private Integer versionNumber;


  /**
   * 省编码(门店管理-省)
   */
  @ApiModelProperty("省编码(门店管理-省)")
  @Column(name = "province_code", length = 32, columnDefinition = "varchar(32) COMMENT '省编码(门店管理-省)'")
  private String provinceCode;

  /**
   * 省名称(门店管理-省)
   */
  @ApiModelProperty("省名称(门店管理-省)")
  @Column(name = "province_name", length = 32, columnDefinition = "varchar(32) COMMENT '省名称(门店管理-省)'")
  private String provinceName;

  /**
   * 是否能再次转换标示(Y:是,N:否)
   */
  @ApiModelProperty("是否能再次转换标示(Y:是,N:否)")
  @TableField(value = "trans_flag")
  @Column(name = "trans_flag", length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否能再次转换标示(Y:是,N:否)'")
  private String transFlag;

  /**
   * 是否已拆单（Y:是,N:否）
   */
  @ApiModelProperty("是否已拆单（Y:是,N:否）")
  @TableField(value = "is_split")
  @Column(name = "is_split", length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否已拆单（Y:是,N:否）'")
  private String isSplit;

  @ApiModelProperty("子验收单集合")
  @TableField(value = "acceptance_split_orders")
  @Column(name = "acceptance_split_orders", length = 255, columnDefinition = "VARCHAR(255) COMMENT '是否已拆单（Y:是,N:否）'")
  private String acceptanceSplitOrders;

  @ApiModelProperty("原验收单ID")
  @TableField(value = "split_before_id")
  @Column(name = "split_before_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '原验收单ID'")
  private String splitBeforeId;

  /**
   * 是否为验收单子单（Y:是,N:否）
   */
  @ApiModelProperty("是否为验收单子单（Y:是,N:否）")
  @TableField(value = "is_slips")
  @Column(name = "is_slips", length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否为验收单子单（Y:是,N:否）'")
  private String isSlips;

  @ApiModelProperty("单据详情")
  @TableField(exist = false)
  @Transient
  private List<InvoiceAcceptanceGoodsEntity> goodsList;
}
