package com.biz.crm.kms.business.invoice.acceptance.local.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 验收单原始单据详情(KmsInvoiceAcceptanceGoodsGrab)实体类
 *
 * @author sunx
 * @since 2022-10-13 17:48:58
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName(value = "kms_invoice_acceptance_goods_grab")
@Table(name = "kms_invoice_acceptance_goods_grab", indexes = {
    @Index(name = "agg_idx1", columnList = "tenant_code,order_number"),
    @Index(name = "agg_idx2", columnList = "tenant_code,ka_order_number"),
})
@ApiModel(value = "KmsInvoiceAcceptanceGoodsGrab", description = "验收单原始单据详情")
@org.hibernate.annotations.Table(appliesTo = "kms_invoice_acceptance_goods_grab", comment = "验收单原始单据详情")
public class KmsInvoiceAcceptanceGoodsGrabEntity extends TenantFlagOpEntity {

  @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
  @TableField(value = "raw_data_id")
  @Column(name = "raw_data_id", length = 128, columnDefinition = "varchar(128) COMMENT '原始数据ID 对应表 kms_grab_response_data 的ID'")
  private String rawDataId;

  @ApiModelProperty("转换标识：0未转换，-1失败，1成功")
  @TableField(value = "trans_status")
  @Column(name = "trans_status", length = 8, columnDefinition = "varchar(8) DEFAULT '0' COMMENT '转换标识：0未转换，-1失败，1成功'")
  private String transStatus;

  @ApiModelProperty("企业验收单编号")
  @TableField(value = "order_number")
  @Column(name = "order_number", length = 64, columnDefinition = "varchar(64) COMMENT '企业验收单编号'")
  private String orderNumber;

  @ApiModelProperty("商超验收单编号")
  @TableField(value = "ka_order_number")
  @Column(name = "ka_order_number", length = 64, columnDefinition = "varchar(64) COMMENT '商超验收单编号'")
  private String kaOrderNumber;

  @ApiModelProperty("企业产品编号")
  @TableField(value = "goods_code")
  @Column(name = "goods_code", length = 64, columnDefinition = "varchar(64) COMMENT '企业产品编号'")
  private String goodsCode;

  @ApiModelProperty("企业产品名称")
  @TableField(value = "goods_name")
  @Column(name = "goods_name", length = 255, columnDefinition = "varchar(255) COMMENT '企业产品名称'")
  private String goodsName;

  @ApiModelProperty("送达方编码")
  @TableField(value = "delivery_party_code")
  @Column(name = "delivery_party_code", length = 32, columnDefinition = "varchar(32) COMMENT '送达方编码'")
  private String deliveryPartyCode;

  @ApiModelProperty("送达方名称")
  @TableField(value = "delivery_party_name")
  @Column(name = "delivery_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '送达方名称'")
  private String deliveryPartyName;

  @ApiModelProperty("商超产品编号")
  @TableField(value = "ka_goods_code")
  @Column(name = "ka_goods_code", length = 64, columnDefinition = "varchar(64) COMMENT '商超产品编号'")
  private String kaGoodsCode;

  @ApiModelProperty("商超产品名称")
  @TableField(value = "ka_goods_name")
  @Column(name = "ka_goods_name", length = 255, columnDefinition = "varchar(255) COMMENT '商超产品名称'")
  private String kaGoodsName;

  @ApiModelProperty("产品国际条码")
  @TableField(value = "goods_bar_code")
  @Column(name = "goods_bar_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品国际条码'")
  private String goodsBarCode;

  @ApiModelProperty("产品规格")
  @TableField(value = "specification")
  @Column(name = "specification", length = 64, columnDefinition = "varchar(64) COMMENT '产品规格'")
  private String specification;

  @ApiModelProperty("验收单价(含税)")
  @TableField(value = "acceptance_one_amount")
  @Column(name = "acceptance_one_amount", length = 20, columnDefinition = "decimal(20,6) COMMENT '验收单价(含税)'")
  private BigDecimal acceptanceOneAmount;

  @ApiModelProperty("验收单价（不含税）")
  @TableField(value = "acceptance_one_amount_not")
  @Column(name = "acceptance_one_amount_not", length = 20, columnDefinition = "decimal(20,6) COMMENT '验收单价（不含税）'")
  private BigDecimal acceptanceOneAmountNot;

  @ApiModelProperty("当前单位验收数量")
  @TableField(value = "cur_unit_acceptance_quantity")
  @Column(name = "cur_unit_acceptance_quantity", length = 20, columnDefinition = "decimal(20,4) COMMENT '当前单位验收数量'")
  private BigDecimal curUnitAcceptanceQuantity;

  @ApiModelProperty("当前单位")
  @TableField(value = "cur_unit")
  @Column(name = "cur_unit", length = 255, columnDefinition = "varchar(255) COMMENT '当前单位'")
  private String curUnit;

  @ApiModelProperty("当前单位层级")
  @TableField(value = "cur_unit_level")
  @Column(name = "cur_unit_level", length = 255, columnDefinition = "varchar(255) COMMENT '当前单位层级'")
  private String curUnitLevel;

  @ApiModelProperty("订货数量")
  @TableField(value = "order_quantity")
  @Column(name = "order_quantity", length = 20, columnDefinition = "decimal(20,4) COMMENT '订货数量'")
  private BigDecimal orderQuantity;

  @ApiModelProperty("订货金额小计（含税）")
  @TableField(value = "order_amount")
  @Column(name = "order_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '订货金额小计（含税）'")
  private BigDecimal orderAmount;

  @ApiModelProperty("验收金额小计（含税）")
  @TableField(value = "acceptance_amount")
  @Column(name = "acceptance_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '验收金额小计（含税）'")
  private BigDecimal acceptanceAmount;

  @ApiModelProperty("订货金额小计（不含税）")
  @TableField(value = "order_amount_not")
  @Column(name = "order_amount_not", length = 20, columnDefinition = "decimal(20,4) COMMENT '订货金额小计（不含税）'")
  private BigDecimal orderAmountNot;

  @ApiModelProperty("验收金额小计（不含税）")
  @TableField(value = "acceptance_amount_not")
  @Column(name = "acceptance_amount_not", length = 20, columnDefinition = "decimal(20,4) COMMENT '验收金额小计（不含税）'")
  private BigDecimal acceptanceAmountNot;

  @ApiModelProperty("售达方名称")
  @TableField(value = "sold_to_party_name")
  @Column(name = "sold_to_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '售达方名称'")
  private String soldToPartyName;

  @ApiModelProperty("售达方编码")
  @TableField(value = "sold_to_party_code")
  @Column(name = "sold_to_party_code", length = 64, columnDefinition = "varchar(64) COMMENT '售达方编码'")
  private String soldToPartyCode;

  @ApiModelProperty("商超编码")
  @TableField(value = "ka_code")
  @Column(name = "ka_code", length = 64, columnDefinition = "varchar(64) COMMENT '商超编码'")
  private String kaCode;

  @ApiModelProperty("商超名称")
  @TableField(value = "ka_name")
  @Column(name = "ka_name", length = 256, columnDefinition = "varchar(256) COMMENT '商超名称'")
  private String kaName;

  @ApiModelProperty("行信息排序")
  @TableField(value = "item_index")
  @Column(name = "item_index", length = -1, columnDefinition = "int COMMENT '行信息排序'")
  private Integer itemIndex;

  @ApiModelProperty("单据版本号")
  @TableField(value = "version_number")
  @Column(name = "version_number", length = -1, columnDefinition = "int COMMENT '单据版本号'")
  private Integer versionNumber;

}
