package com.biz.crm.kms.business.invoice.acceptance.local.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 验收单原始数据表(KmsInvoiceAcceptanceGrab)实体类
 *
 * @author sunx
 * @since 2022-10-13 17:48:56
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName(value = "kms_invoice_acceptance_grab")
@Table(name = "kms_invoice_acceptance_grab", indexes = {
    @Index(name = "ag_idx1", columnList = "tenant_code,order_number"),
    @Index(name = "ag_idx2", columnList = "tenant_code,ka_order_number"),
    @Index(name = "ag_idx3", columnList = "trans_status"),
    @Index(name = "ag_idx4", columnList = "direct_code"),
})
@ApiModel(value = "KmsInvoiceAcceptanceGrab", description = "验收单原始数据表")
@org.hibernate.annotations.Table(appliesTo = "kms_invoice_acceptance_grab", comment = "验收单原始数据表")
public class KmsInvoiceAcceptanceGrabEntity extends TenantFlagOpEntity {

  @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
  @TableField(value = "raw_data_id")
  @Column(name = "raw_data_id", length = 128, columnDefinition = "varchar(128) COMMENT '原始数据ID 对应表 kms_grab_response_data 的ID'")
  private String rawDataId;

  @ApiModelProperty("转换标识：0未转换，-1失败，1成功")
  @TableField(value = "trans_status")
  @Column(name = "trans_status", length = 8, columnDefinition = "varchar(8) DEFAULT '0' COMMENT '转换标识：0未转换，-1失败，1成功'")
  private String transStatus;

  @ApiModelProperty("转换描述")
  @TableField(value = "trans_msg")
  @Column(name = "trans_msg", length = 8, columnDefinition = "varchar(256) COMMENT '转换描述'")
  private String transMsg;

  /**
   * [数据字典:mdm_business_format]
   */
  @ApiModelProperty("业态")
  @TableField(value = "business_format_code")
  @Column(name = "business_format_code", length = 64, columnDefinition = "varchar(64) COMMENT '业态'")
  private String businessFormatCode;

  /**
   * [数据字典:mdm_business_unit]
   */
  @ApiModelProperty("业务单元编码")
  @TableField(value = "business_unit_code")
  @Column(name = "business_unit_code", length = 64, columnDefinition = "varchar(64) COMMENT '业务单元编码'")
  private String businessUnitCode;

  @ApiModelProperty("售达方名称")
  @TableField(value = "sold_to_party_name")
  @Column(name = "sold_to_party_name", length = 256, columnDefinition = "varchar(256) COMMENT '售达方名称'")
  private String soldToPartyName;

  @ApiModelProperty("售达方编码")
  @TableField(value = "sold_to_party_code")
  @Column(name = "sold_to_party_code", length = 64, columnDefinition = "varchar(64) COMMENT '售达方编码'")
  private String soldToPartyCode;

  @ApiModelProperty("企业门店/大仓编号")
  @TableField(value = "store_code")
  @Column(name = "store_code", length = 64, columnDefinition = "varchar(64) COMMENT '企业门店/大仓编号'")
  private String storeCode;

  @ApiModelProperty("企业门店/大仓名称")
  @TableField(value = "store_name")
  @Column(name = "store_name", length = 256, columnDefinition = "varchar(256) COMMENT '企业门店/大仓名称'")
  private String storeName;

  @ApiModelProperty("送达方编码")
  @TableField(value = "delivery_party_code")
  @Column(name = "delivery_party_code", length = 32, columnDefinition = "varchar(32) COMMENT '送达方编码'")
  private String deliveryPartyCode;

  @ApiModelProperty("送达方名称")
  @TableField(value = "delivery_party_name")
  @Column(name = "delivery_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '送达方名称'")
  private String deliveryPartyName;

  @ApiModelProperty("关联结算单号")
  @Column(name = "code",length = 32,columnDefinition = "varchar(32) COMMENT  '关联结算单号'")
  private String code;

  @ApiModelProperty("直营体系编码")
  @TableField(value = "direct_code")
  @Column(name = "direct_code", length = 32, columnDefinition = "varchar(32) COMMENT '直营体系编码'")
  private String directCode;

  @ApiModelProperty("关联企业订货单编号")
  @TableField(value = "relate_order_number")
  @Column(name = "relate_order_number", length = 64, columnDefinition = "varchar(64) COMMENT '关联企业订货单编号'")
  private String relateOrderNumber;

  @ApiModelProperty("关联商超订货单编号")
  @TableField(value = "relate_ka_order_number")
  @Column(name = "relate_ka_order_number", length = 64, columnDefinition = "varchar(64) COMMENT '关联商超订货单编号'")
  private String relateKaOrderNumber;

  @ApiModelProperty("企业验收单编号")
  @TableField(value = "order_number")
  @Column(name = "order_number", length = 64, columnDefinition = "varchar(64) COMMENT '企业验收单编号'")
  private String orderNumber;

  @ApiModelProperty("商超验收单编号")
  @TableField(value = "ka_order_number")
  @Column(name = "ka_order_number", length = 64, columnDefinition = "varchar(64) COMMENT '商超验收单编号'")
  private String kaOrderNumber;

  @ApiModelProperty("验收日期")
  @TableField(value = "acceptance_date")
  @Column(name = "acceptance_date" , length = 32, columnDefinition = "varchar(32) COMMENT '验收日期'")
  private String acceptanceDate;

  @ApiModelProperty("验收类型")
  @TableField(value = "acceptance_type")
  @Column(name = "acceptance_type", length = 64, columnDefinition = "varchar(64) COMMENT '验收类型'")
  private String acceptanceType;

  @ApiModelProperty("单据来源")
  @TableField(value = "invoices_source")
  @Column(name = "invoices_source", length = 64, columnDefinition = "varchar(64) COMMENT '单据来源'")
  private String invoicesSource;

  @ApiModelProperty("商超编码")
  @TableField(value = "ka_code")
  @Column(name = "ka_code", length = 64, columnDefinition = "varchar(64) COMMENT '商超编码'")
  private String kaCode;

  @ApiModelProperty("商超名称")
  @TableField(value = "ka_name")
  @Column(name = "ka_name", length = 256, columnDefinition = "varchar(256) COMMENT '商超名称'")
  private String kaName;

  @ApiModelProperty("商超门店/大仓编号")
  @TableField(value = "ka_store_code")
  @Column(name = "ka_store_code", length = 64, columnDefinition = "varchar(64) COMMENT '商超门店/大仓编号'")
  private String kaStoreCode;

  @ApiModelProperty("商超门店/大仓名称")
  @TableField(value = "ka_store_name")
  @Column(name = "ka_store_name", length = 256, columnDefinition = "varchar(256) COMMENT '商超门店/大仓名称'")
  private String kaStoreName;

  @ApiModelProperty("订货单总金额（含税）")
  @TableField(value = "final_order_amount")
  @Column(name = "final_order_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '订货单总金额（含税）'")
  private BigDecimal finalOrderAmount;

  @ApiModelProperty("订货单总金额（不含税）")
  @TableField(value = "final_order_amount_not")
  @Column(name = "final_order_amount_not", length = 20, columnDefinition = "decimal(20,4) COMMENT '订货单总金额（不含税）'")
  private BigDecimal finalOrderAmountNot;

  @ApiModelProperty("验收单总金额（含税）")
  @TableField(value = "final_acceptance_amount")
  @Column(name = "final_acceptance_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '验收单总金额（含税）'")
  private BigDecimal finalAcceptanceAmount;

  @ApiModelProperty("验收单总金额（不含税）")
  @TableField(value = "final_acceptance_amount_not")
  @Column(name = "final_acceptance_amount_not", length = 20, columnDefinition = "decimal(20,4) COMMENT '验收单总金额（不含税）'")
  private BigDecimal finalAcceptanceAmountNot;

  @ApiModelProperty("业务区域负责人")
  @TableField(value = "business_area_leader")
  @Column(name = "business_area_leader", length = 64, columnDefinition = "varchar(64) COMMENT '业务区域负责人'")
  private String businessAreaLeader;

  @ApiModelProperty("业务区域")
  @TableField(value = "business_area")
  @Column(name = "business_area", length = 64, columnDefinition = "varchar(64) COMMENT '业务区域'")
  private String businessArea;

  @ApiModelProperty("区域编码")
  @TableField(value = "area_code")
  @Column(name = "area_code", length = 64, columnDefinition = "varchar(64) COMMENT '区域编码'")
  private String areaCode;

  @ApiModelProperty("区域名称")
  @TableField(value = "area_name")
  @Column(name = "area_name", length = 256, columnDefinition = "varchar(256) COMMENT '区域名称'")
  private String areaName;

  @ApiModelProperty("登录账号")
  @TableField(value = "user_name")
  @Column(name = "user_name", length = 64, columnDefinition = "varchar(64) COMMENT '登录账号'")
  private String userName;

  @ApiModelProperty("供应商名称")
  @TableField(value = "supplier_name")
  @Column(name = "supplier_name", length = 256, columnDefinition = "varchar(256) COMMENT '供应商名称'")
  private String supplierName;

  @ApiModelProperty("供应商编码")
  @TableField(value = "supplier_code")
  @Column(name = "supplier_code", length = 64, columnDefinition = "varchar(64) COMMENT '供应商编码'")
  private String supplierCode;

  @ApiModelProperty("单据版本号")
  @TableField(value = "version_number")
  @Column(name = "version_number", length = -1, columnDefinition = "int COMMENT '单据版本号'")
  private Integer versionNumber;

  @ApiModelProperty("单据详情")
  @TableField(exist = false)
  @Transient
  private List<KmsInvoiceAcceptanceGoodsGrabEntity> goodsList;
}
