package com.biz.crm.kms.business.invoice.acceptance.local.exports.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Class InvoiceAcceptenceExportDto
 * @Description 验收单导出入参
 * @Author : ZS
 * @Date: 2023/1/7  16:21
 */
@Data
@ApiModel(value = "InvoiceAcceptenceExportDto", description = "验收单导出入参Dto")
public class InvoiceAcceptenceExportDto extends TenantFlagOpDto {

    @ApiModelProperty("*零售商验收单编号")
    private String kaOrderNumber;

    @ApiModelProperty("*关联商超订货单编号")
    private String relateKaOrderNumber;

    @ApiModelProperty("*企业验收单编号")
    private String orderNumber;

    @ApiModelProperty("*系统编码")
    private String directCode;

    @ApiModelProperty("*系统名称")
    private String directName;

    @ApiModelProperty("*系统名称")
    private String kaName;

    @ApiModelProperty("*业态")
    private String businessFormatCode;

    @ApiModelProperty("*业务单元")
    private String businessUnitCode;

    @ApiModelProperty("*售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("*售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("*送达方编码")
    private String deliveryPartyCode;

    @ApiModelProperty("*送达方名称")
    private String deliveryPartyName;

    @ApiModelProperty("*零售商门店编码")
    private String kaStoreCode;

    @ApiModelProperty("*零售商门店名称")
    private String kaStoreName;

    @ApiModelProperty("零售商区域编码")
    private String areaCode;

    @ApiModelProperty("零售商区域名称")
    private String areaName;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("*验收日期")
    private String acceptanceDate;

    @ApiModelProperty("*验收类型")
    private String acceptanceType;

    @ApiModelProperty("*验收总金额")
    private String finalAcceptanceAmount;

    @ApiModelProperty("*验收总金额（不含税）")
    private String finalAcceptanceAmountNot;

    @ApiModelProperty("*单据来源")
    private String invoicesSource;

    @ApiModelProperty("*商超编码")
    private String kaCode;

    @ApiModelProperty("*产品编号")
    private String productCode;

    @ApiModelProperty("*产品名称")
    private String productName;

    @ApiModelProperty("*零售商产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("*零售商产品编号")
    private String kaGoodsName;

    @ApiModelProperty("*产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("*验收单价")
    private String acceptanceOneAmountStr;

    @ApiModelProperty("*产品规格")
    private String specification;

    @ApiModelProperty("*单位")
    private String curUnit;

    @ApiModelProperty("*订货数量")
    private String orderQuantityStr;

    @ApiModelProperty("*验收数量")
    private String curUnitAcceptanceQuantityStr;

    @ApiModelProperty("*验收单金额小计（不含税）")
    private String acceptanceAmountNotStr;

    @ApiModelProperty("*验收单金额小计（含税）")
    private String acceptanceAmountStr;

    @ApiModelProperty("*关联结算单号")
    private String statementCode;

    @ApiModelProperty("*验收开始时间")
    private String beginDate;

    @ApiModelProperty("*验收结束时间")
    private String endDate;

    @ApiModelProperty("*转换状态")
    private String orderStatus;

    @ApiModelProperty("*登录账号")
    private String userName;

}
