package com.biz.crm.kms.business.invoice.acceptance.local.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.business.invoice.acceptance.local.exports.dto.InvoiceAcceptenceExportDto;
import com.biz.crm.kms.business.invoice.acceptance.local.exports.mapper.InvoiceAcceptanceExportMapper;
import com.biz.crm.kms.business.invoice.acceptance.local.exports.vo.InvoiceAcceptenceExportVo;
import com.biz.crm.kms.business.invoice.acceptance.sdk.constant.AcceptanceOrderConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import io.swagger.models.auth.In;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Class InvoiceAcceptanceExportProcess
 * @Description 验收单明细导出
 * @Author : ZS
 * @Date: 2023/1/7  17:16
 */
@Component
@Slf4j
public class InvoiceAcceptanceExportProcess implements ExportProcess<InvoiceAcceptenceExportVo> {

    @Autowired(required = false)
    private InvoiceAcceptanceExportMapper invoiceAcceptanceExportMapper;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private RedisService redisService;

    @Override
     public Integer getPageSize() {
        return 50000;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        InvoiceAcceptenceExportDto dto = this.convertParams(params);
        Page<InvoiceAcceptenceExportVo> pageResult = this.invoiceAcceptanceExportMapper.findByConditions(new Page<>(0, 1), dto);
        log.info("验收单获取到的总数量为{}",pageResult.getTotal());
        return ((int) (pageResult.getTotal()));
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
        //分页问题修改
        if(processVo.getPageNo() == null){
            throw new IllegalArgumentException("参数错误");
        }
        processVo.setPageNo(processVo.getPageNo()+1);
        InvoiceAcceptenceExportDto dto = this.convertParams(params);
        log.info("验收单分页页数为{}，条数为{}",processVo.getPageNo(),processVo.getPageSize());
        Page<InvoiceAcceptenceExportDto> pageable = new Page<>(processVo.getPageNo(), this.getPageSize());
        //获取缓存税率
        Object o = redisService.get(AcceptanceOrderConstant.CACHE_PRODUCT_TAX_RATE);
        Map<String,BigDecimal> productTaxMap = (Map<String, BigDecimal>) o;
        log.info("验收单分页页数为{}，条数为{}",pageable.getCurrent(),pageable.getSize());
        Page<InvoiceAcceptenceExportVo> page = this.invoiceAcceptanceExportMapper.findByConditions(pageable, dto);
        this.buildVo(page.getRecords(),productTaxMap);
        return JSON.parseArray(JSON.toJSONString((page.getRecords())));
    }

    @Override
    public Class<InvoiceAcceptenceExportVo> findCrmExcelVoClass() {
        return InvoiceAcceptenceExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "KMS_INVOICE_ACCEPTANCE_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "KMS单据-验收单导出";
    }



    /**
     * 转换参数
     *
     * @param params 传递参数
     * @return 转换结果
     */
    private InvoiceAcceptenceExportDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        params.remove("sort");
        params.remove("europaInfoCode");
        Map<String, Object> map = params.entrySet().stream()
                .collect(Collectors.toMap(e -> e.getKey().substring(0, e.getKey().lastIndexOf("_")), Map.Entry::getValue,(a,b)->a));
        List<String> dateList = new ArrayList<>();
        params.forEach((k,v)->{
            if (k.contains("acceptance_time")){
                dateList.add(v.toString());
            }
        });
        if (CollectionUtils.isNotEmpty(dateList)){
            Collections.sort(dateList);
            if (dateList.size() > 1){
                map.put("beginDate",dateList.get(0));
                map.put("endDate",dateList.get(1));
            }
        }
        InvoiceAcceptenceExportDto dto = JSON.parseObject(JSON.toJSONString(map), InvoiceAcceptenceExportDto.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return dto;
    }

    private void buildVo(List<InvoiceAcceptenceExportVo> page ,Map<String,BigDecimal> productTaxMap){
        if (org.springframework.util.CollectionUtils.isEmpty(page)){
            return;
        }
        Map<String, String> businessFormatMap = new HashMap<>();
        Map<String, String> businessUnitMap = new HashMap<>();
        Map<String, String> bussinessAreaMap = new HashMap<>();
        Map<String, String> orderStatusMap = new HashMap<>();
        List<DictDataVo> businessFormat = dictDataVoService.findByDictTypeCode("mdm_business_format");
        List<DictDataVo> businessUnit = dictDataVoService.findByDictTypeCode("mdm_business_unit");
        List<DictDataVo> bussinessArea = dictDataVoService.findByDictTypeCode("MDM_CUSTOMIZE_ORG");
        List<DictDataVo> orderStatus = dictDataVoService.findByDictTypeCode("kms_order_status");
        if (CollectionUtils.isNotEmpty(businessFormat)){
            businessFormatMap = businessFormat.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        if (CollectionUtils.isNotEmpty(businessUnit)){
            businessUnitMap = businessUnit.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        if (CollectionUtils.isNotEmpty(bussinessArea)){
            bussinessAreaMap = bussinessArea.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a,b) ->a));
        }
        if (CollectionUtils.isNotEmpty(orderStatus)){
            orderStatusMap = orderStatus.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a,b) ->a));
        }
        for (InvoiceAcceptenceExportVo invoiceAcceptenceExportVo : page) {
            invoiceAcceptenceExportVo.setBusinessUnitCode(businessUnitMap.get(invoiceAcceptenceExportVo.getBusinessUnitCode()));
            invoiceAcceptenceExportVo.setBusinessFormatCode(businessFormatMap.get(invoiceAcceptenceExportVo.getBusinessFormatCode()));
            invoiceAcceptenceExportVo.setBusinessArea(bussinessAreaMap.get(invoiceAcceptenceExportVo.getBusinessArea()));
            invoiceAcceptenceExportVo.setOrderStatus(orderStatusMap.get(invoiceAcceptenceExportVo.getOrderStatus()));
            invoiceAcceptenceExportVo.setGoodsOrderStatus(orderStatusMap.get(invoiceAcceptenceExportVo.getGoodsOrderStatus()));
            //税率
            if (Objects.nonNull(productTaxMap)){
                if (Objects.nonNull(productTaxMap.get(invoiceAcceptenceExportVo.getGoodsCode()))){
                    invoiceAcceptenceExportVo.setRax(productTaxMap.get(invoiceAcceptenceExportVo.getGoodsCode()));
                }
            }
        }
    }
}
