package com.biz.crm.kms.business.invoice.acceptance.local.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Class InvoiceAcceptenceExportVo
 * @Description 验收单导出Vo
 * @Author : ZS
 * @Date: 2023/1/7  16:51
 */
@Data
@ApiModel(value = "InvoiceAcceptenceExportVo", description = "验收单导出Vo")
@CrmExcelExport
public class InvoiceAcceptenceExportVo extends CrmExcelVo {
    @CrmExcelColumn("*零售商验收单编号")
    private String kaOrderNumber;

    @CrmExcelColumn("*关联商超订货单编号")
    private String relateKaOrderNumber;

    @CrmExcelColumn("*系统编码")
    private String directCode;

    @CrmExcelColumn("*系统名称")
    private String kaName;

    @CrmExcelColumn("*转换状态")
    private String orderStatus;

    @CrmExcelColumn("*转换状态描述")
    private String orderStatusMsg;

    @CrmExcelColumn("*业态")
    private String businessFormatCode;

    @CrmExcelColumn("*业务单元")
    private String businessUnitCode;

    @CrmExcelColumn("*售达方编码")
    private String soldToPartyCode;

    @CrmExcelColumn("*售达方名称")
    private String soldToPartyName;

    @CrmExcelColumn("*送达方编码")
    private String deliveryPartyCode;

    @CrmExcelColumn("*送达方名称")
    private String deliveryPartyName;

    @CrmExcelColumn("*零售商门店编码")
    private String kaStoreCode;

    @CrmExcelColumn("*零售商门店名称")
    private String kaStoreName;

    @CrmExcelColumn("零售商区域编码")
    private String areaCode;

    @CrmExcelColumn("零售商区域名称")
    private String areaName;

    @CrmExcelColumn("业务区域")
    private String businessArea;

    @CrmExcelColumn("省编码(门店管理-省)")
    private String provinceCode;

    @CrmExcelColumn("省名称(门店管理-省)")
    private String provinceName;

    @CrmExcelColumn("*验收日期")
    private String acceptanceDate;

    @CrmExcelColumn("*验收总金额")
    private BigDecimal finalAcceptanceAmount;

    @CrmExcelColumn("*验收总金额（不含税）")
    private BigDecimal finalAcceptanceAmountNot;

    @CrmExcelColumn("*验收类型")
    private String acceptanceType;

    @CrmExcelColumn("*单据来源")
    private String invoicesSource;

    @CrmExcelColumn("*明细转换状态")
    private String goodsOrderStatus;

    @CrmExcelColumn("*明细转换状态描述")
    private String goodsOrderStatusMsg;

    @CrmExcelColumn("*产品编号")
    private String goodsCode;

    @CrmExcelColumn("*产品名称")
    private String goodsName;

    @CrmExcelColumn("*零售商产品编号")
    private String kaGoodsCode;

    @CrmExcelColumn("*零售商产品编号")
    private String kaGoodsName;

    @CrmExcelColumn("*产品国际条码")
    private String goodsBarCode;

    @CrmExcelColumn("*税率")
    private BigDecimal rax;

    @CrmExcelColumn("*验收单价（含税）")
    private BigDecimal acceptanceOneAmount;

    @CrmExcelColumn("*验收单价（不含税）")
    private BigDecimal acceptanceOneAmountNot;

    @CrmExcelColumn("*产品规格")
    private String specification;

    @CrmExcelColumn("*单位")
    private String curUnit;

    @CrmExcelColumn("*订货数量")
    private BigDecimal orderQuantity;

    @CrmExcelColumn("*验收数量")
    private BigDecimal curUnitAcceptanceQuantity;

    @CrmExcelColumn("*转换后数量")
    private BigDecimal curCompanyUnitOrderQuantity;

    @CrmExcelColumn("*转换后单位")
    private String curCompanyUnitName;

    @CrmExcelColumn("*验收单金额小计（不含税）")
    private BigDecimal acceptanceAmountNot;

    @CrmExcelColumn("*验收单金额小计（含税）")
    private BigDecimal acceptanceAmount;

    @CrmExcelColumn("*关联结算单号")
    private String statementCode;

    @CrmExcelColumn("*登录账号")
    private String userName;
}
