package com.biz.crm.kms.business.invoice.acceptance.local.imports.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Class InvoiceAcceptanceOrderImprotVo
 * @Description 单据-验收单导入模板
 * @Author : cyj
 * @Date: 2022/11/28  14:18
 */
@Data
@CrmExcelImport(startRow = 2)
public class InvoiceAcceptanceOrderImportsVo extends CrmExcelVo {

    @CrmExcelColumn("*KMS验收单编号")
    private String orderNumber;

    @CrmExcelColumn("*零售商验收单编号")
    private String kaOrderNumber;

    @CrmExcelColumn("*关联零售商采购单号")
    private String relateKaOrderNumber;

    @CrmExcelColumn("*系统编码")
    private String directCode;

    @CrmExcelColumn("*系统名称")
    private String kaName;

    @CrmExcelColumn("*业态")
    private String businessFormatCode;

    @CrmExcelColumn("*业务单元")
    private String businessUnitCode;

    @CrmExcelColumn("*售达方编码")
    private String soldToPartyCode;

    @CrmExcelColumn("*售达方名称")
    private String soldToPartyName;

    @CrmExcelColumn("*送达方编码")
    private String deliveryPartyCode;

    @CrmExcelColumn("*送达方名称")
    private String deliveryPartyName;

    @CrmExcelColumn("*零售商门店编码")
    private String kaStoreCode;

    @CrmExcelColumn("*零售商门店名称")
    private String kaStoreName;

    @CrmExcelColumn("零售商区域编码")
    private String areaCode;

    @CrmExcelColumn("零售商区域名称")
    private String areaName;

    @CrmExcelColumn("业务区域")
    private String businessArea;

    @CrmExcelColumn("*验收日期")
    private String acceptanceDate;

    @CrmExcelColumn("*产品编号")
    private String productCode;

    @CrmExcelColumn("*产品名称")
    private String productName;

    @CrmExcelColumn("*零售商产品编号")
    private String kaGoodsCode;

    @CrmExcelColumn("*零售商产品名称")
    private String kaGoodsName;

    @CrmExcelColumn("*产品国际条码")
    private String goodsBarCode;

    @CrmExcelColumn("*验收单价")
    private String acceptanceOneAmountStr;

    @CrmExcelColumn("规格型号")
    private String specification;

    @CrmExcelColumn("*单位")
    private String curUnit;

    @CrmExcelColumn("*订货数量")
    private String orderQuantityStr;

    @CrmExcelColumn("*验收数量")
    private String curUnitAcceptanceQuantityStr;

    @CrmExcelColumn("*验收单金额小计（不含税）")
    private String acceptanceAmountNotStr;

    @CrmExcelColumn("*验收单金额小计（含税）")
    private String acceptanceAmountStr;

    @CrmExcelColumn("*关联结算单号")
    private String statementCode;
}
