package com.biz.crm.kms.business.invoice.acceptance.local.imports.service;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGoodsGrabEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGrabEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.imports.model.InvoiceAcceptanceOrderImportsVo;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGrabService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceOrderImportsService;
import com.biz.crm.kms.business.invoice.sdk.constant.DirectConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;

/**
 * @Class InvoiceAcceptanceOrderImportPre
 * @Description 单据-验收单导入服务层
 * @Author : cyj
 * @Date: 2022/11/28  14:19
 */
@Slf4j
@Component
public class InvoiceAcceptanceOrderImportsProcess implements ImportProcess<InvoiceAcceptanceOrderImportsVo> {

    @Autowired
    private InvoiceAcceptanceOrderImportsService importSave;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private InvoiceAcceptanceGrabService invoiceAcceptanceGrabService;

    /**
     * 表示当前导入excel中无论多少条数据，分批处理过程每次处理多少条数据
     */
    @Override
    public Integer getBatchCount() {
        return 10000;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, InvoiceAcceptanceOrderImportsVo> data,
                                        TaskGlobalParamsVo paramsVo,
                                        Map<String, Object> params) {
        if (CollectionUtils.isEmpty(data.values())) {
            return Maps.newHashMap();
        }
        log.info("数据：{}", data.values());

        Map<String,InvoiceAcceptanceEntity> importMap = Maps.newHashMap();

        List<DictDataVo> fomatList = this.dictDataVoService.findByDictTypeCode(DirectConstant.MDM_BUSINESS_FORMAT);

        Map<String,String> fomatMap = Maps.newHashMap();
        for(DictDataVo vo : fomatList){
            fomatMap.put(vo.getDictValue(),vo.getDictCode());
        }

        List<DictDataVo> unitList = this.dictDataVoService.findByDictTypeCode(DirectConstant.MDM_BUSINESS_UNIT);

        Map<String,String> unitMap = Maps.newHashMap();
        for(DictDataVo vo : unitList){
            unitMap.put(vo.getDictValue(),vo.getDictCode());
        }

        Map<Integer, String> response = Maps.newHashMap();

        StringBuilder error = new StringBuilder();

        InvoiceAcceptanceEntity entity = new InvoiceAcceptanceEntity();

        InvoiceAcceptanceGoodsEntity goodsEntity = new InvoiceAcceptanceGoodsEntity();

        List<InvoiceAcceptanceGoodsEntity> goodsEntityList = Lists.newArrayList();

        for(Map.Entry<Integer, InvoiceAcceptanceOrderImportsVo> importVo :data.entrySet()){
            Integer index = importVo.getKey();
            InvoiceAcceptanceOrderImportsVo vo = importVo.getValue();
            error = new StringBuilder();
            try {
                this.check(vo);
            }catch (Exception e){
                error.append(e);
            }
            if(importMap.get(vo.getKaOrderNumber())==null){
                entity = this.nebulaToolkitService
                        .copyObjectByWhiteList(vo,InvoiceAcceptanceEntity.class,HashSet.class,ArrayList.class);
            }else{
                entity = importMap.get(vo.getKaOrderNumber());
            }

            entity.setTenantCode(TenantUtils.getTenantCode());

            entity.setBusinessFormatCode(fomatMap.get(vo.getBusinessFormatCode()));

            entity.setBusinessUnitCode(unitMap.get(vo.getBusinessUnitCode()));

            if(StringUtils.isEmpty(entity.getOrderNumber())){
                entity.setOrderNumber("YS"+System.currentTimeMillis());
            }

            goodsEntity = this.nebulaToolkitService.copyObjectByWhiteList(
                    vo,InvoiceAcceptanceGoodsEntity.class,HashSet.class,ArrayList.class);

            goodsEntity.setTenantCode(TenantUtils.getTenantCode());

            goodsEntity.setOrderNumber(entity.getOrderNumber());

            try {
                this.goodsAmountTrans(vo,goodsEntity);
            }catch (Exception e){
                error.append("金额转换错误："+e);
            }

            try {
                this.amountTotal(entity,goodsEntity);
            }catch (Exception e){
                error.append("金额计算错误："+e);
            }

            if(CollectionUtils.isEmpty(entity.getGoodsList())){
                goodsEntityList = Lists.newArrayList();
                goodsEntityList.add(goodsEntity);
                entity.setGoodsList(goodsEntityList);
            }else{
                goodsEntityList = entity.getGoodsList();
                goodsEntityList.add(goodsEntity);
                entity.setGoodsList(goodsEntityList);
            }

            importMap.put(vo.getKaOrderNumber(),entity);

            if (error.length() > 0) {
                response.put(index, error.toString());
                continue;
            }

        }

        List<InvoiceAcceptanceEntity> entityList = Lists.newArrayList();

        List<KmsInvoiceAcceptanceGrabEntity> grabEntityList = new ArrayList<>();

        for(InvoiceAcceptanceEntity acceptanceEntity: importMap.values()){
            try {
                KmsInvoiceAcceptanceGrabEntity grabEntity = this.nebulaToolkitService
                        .copyObjectByWhiteList(acceptanceEntity, KmsInvoiceAcceptanceGrabEntity.class, HashSet.class, ArrayList.class);
                List<KmsInvoiceAcceptanceGoodsGrabEntity> grabGoods = (List<KmsInvoiceAcceptanceGoodsGrabEntity>)this.nebulaToolkitService
                        .copyCollectionByWhiteList(acceptanceEntity.getGoodsList(), InvoiceAcceptanceGoodsEntity.class, KmsInvoiceAcceptanceGoodsGrabEntity.class, HashSet.class, ArrayList.class);
                grabEntity.setGoodsList(grabGoods);
                grabEntityList.add(grabEntity);
            }catch (Exception e){
                log.error("验收单原始信息转换错误={}",e);
            }

            entityList.add(acceptanceEntity);
        }
        log.info("开始保存验收单数据={}",JSON.toJSONString(entityList));
        this.importSave.importsSave(entityList);
        log.info("开始保存验收单原始数据={}",JSON.toJSONString(grabEntityList));
        this.invoiceAcceptanceGrabService.importSave(grabEntityList);
        return response;
    }

    private void check(InvoiceAcceptanceOrderImportsVo vo){
        Validate.isTrue(StringUtils.isNotBlank(vo.getKaOrderNumber()),"零售商验收单编号不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getRelateKaOrderNumber()),"关联零售商采购单号不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getDirectCode()),"系统编码不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getKaName()),"系统名称不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getBusinessFormatCode()),"业态不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getBusinessUnitCode()),"业务单元不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getKaStoreCode()),"零售商门店编码不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getKaStoreName()),"零售商门店名称不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getAcceptanceDate()),"验收日期不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getKaGoodsCode()),"零售商产品编码不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getKaGoodsName()),"零售商产品名称不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getAcceptanceOneAmountStr()),"验收单价不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getCurUnitAcceptanceQuantityStr()),"验收数量不能为空");
        Validate.isTrue(StringUtils.isNotBlank(vo.getAcceptanceAmountNotStr())||StringUtils.isNotBlank(vo.getAcceptanceAmountStr()),"验收金额小计（不含税）或验收金额小计（含税）不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getAcceptanceAmountStr()),"验收金额小计（含税）不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getOrderNumber()),"KMS验收单编号不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getProductCode()),"产品编码不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getProductName()),"产品名称不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getStatementCode()),"关联结算单号不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getSoldToPartyCode()),"售达方编码不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getSoldToPartyName()),"售达方名称不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getDeliveryPartyCode()),"送达方编码不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getDeliveryPartyName()),"送达方名称不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getGoodsBarCode()),"产品国际条码不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getCurUnit()),"单位不能为空");
//        Validate.isTrue(StringUtils.isNotBlank(vo.getOrderQuantityStr()),"订货数量不能为空");
    }

    /**
     * 金额转换
     * @param vo
     * @param entity
     */
    private void goodsAmountTrans(InvoiceAcceptanceOrderImportsVo vo,InvoiceAcceptanceGoodsEntity entity){
        if (StringUtils.isNotBlank(vo.getAcceptanceOneAmountStr())){
            BigDecimal acceptanceOneAmount = new BigDecimal(vo.getAcceptanceOneAmountStr());
            entity.setAcceptanceOneAmount(acceptanceOneAmount);
        }
        if (StringUtils.isNotBlank(vo.getOrderQuantityStr())){
            BigDecimal orderQuantity = new BigDecimal(vo.getOrderQuantityStr());
            entity.setOrderQuantity(orderQuantity);
        }
        if (StringUtils.isNotBlank(vo.getCurUnitAcceptanceQuantityStr())){
            BigDecimal curUnitAcceptanceQuantity = new BigDecimal(vo.getCurUnitAcceptanceQuantityStr());
            entity.setCurUnitAcceptanceQuantity(curUnitAcceptanceQuantity);
        }
        if (StringUtils.isNotBlank(vo.getAcceptanceAmountNotStr())){
            BigDecimal acceptanceAmountNot = new BigDecimal(vo.getAcceptanceAmountNotStr());
            entity.setAcceptanceAmountNot(acceptanceAmountNot);
        }
        if (StringUtils.isNotBlank(vo.getAcceptanceAmountStr())){
            BigDecimal acceptanceAmount = new BigDecimal(vo.getAcceptanceAmountStr());
            entity.setAcceptanceAmount(acceptanceAmount);
        }
    }

    /**
     * 验收金额计算
     * @return
     */
    private void amountTotal(InvoiceAcceptanceEntity entity,InvoiceAcceptanceGoodsEntity goodsEntity){
        //验收单总金额（含税）
        BigDecimal finalAcceptanceAmount = BigDecimal.ZERO;
        //验收单总金额（不含税）
        BigDecimal finalAcceptanceAmountNot = BigDecimal.ZERO;
        if(entity.getFinalAcceptanceAmount()!=null && entity.getFinalAcceptanceAmount().compareTo(BigDecimal.ZERO)!=0){
            finalAcceptanceAmount = entity.getFinalAcceptanceAmount();
        }
        if(entity.getFinalAcceptanceAmountNot()!=null && entity.getFinalAcceptanceAmountNot().compareTo(BigDecimal.ZERO)!=0){
            finalAcceptanceAmountNot = entity.getFinalAcceptanceAmountNot();
        }
        if(goodsEntity.getAcceptanceAmount()!=null){
            finalAcceptanceAmount = finalAcceptanceAmount.add(goodsEntity.getAcceptanceAmount());
        }
        if(goodsEntity.getAcceptanceAmountNot()!=null){
            finalAcceptanceAmountNot = finalAcceptanceAmountNot.add(goodsEntity.getAcceptanceAmountNot());
        }
        //设置验收单金额
        entity.setFinalAcceptanceAmount(finalAcceptanceAmount);
        entity.setFinalAcceptanceAmountNot(finalAcceptanceAmountNot);
    }



    @Override
    public Class<InvoiceAcceptanceOrderImportsVo> findCrmExcelVoClass() {
        return InvoiceAcceptanceOrderImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "KMS_ACCEPTANCE_ORDER_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "企业验收单导入";
    }
}
