package com.biz.crm.kms.business.invoice.acceptance.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import java.util.Date;
import java.util.List;

import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceGoodsVo;
import org.apache.ibatis.annotations.Param;

/**
 * 验收单商品表(InvoiceAcceptanceGoods)表数据库访问层
 *
 * @author pengxi
 * @date 2022/10/10
 */
public interface InvoiceAcceptanceGoodsMapper extends BaseMapper<InvoiceAcceptanceGoodsEntity> {

  /**
   * 根据多条件查询数据
   *
   * @param invoiceDates   单据日期
   * @param goodsCodes     商品编码
   * @param storeCodes     门店编码
   * @param kaOrderNumbers 商超订单编码
   * @return 数据集合
   */
  List<InvoiceAcceptanceGoodsEntity> findInvoiceStatistics(@Param("invoiceDates") List<Date> invoiceDates, @Param("goodsCodes") List<String> goodsCodes, @Param("storeCodes") List<String> storeCodes,
      @Param("kaOrderNumbers") List<String> kaOrderNumbers);

  /**
   * 根据id集合查询数据
   * @param ids
   * @return
   */
  List<InvoiceAcceptanceGoodsEntity> findByRelationId(@Param("ids") List<String> ids);

  /**
   * 窜单匹配查验收单
   * @param relationKaOrderCodes
   * @param acceptanceOrderNumber
   * @return
   */
  List<InvoiceAcceptanceGoodsEntity> findCrossByConditions(@Param("relationKaOrderCodes") List<String> relationKaOrderCodes,@Param("acceptanceOrderNumbers") List<String> acceptanceOrderNumber);

  /**
   * 多条件查询验收单数据
   *
   * @param goodsCodes
   * @param storeCodes
   * @param orderCodes
   * @param beginDate
   * @param endDate
   * @param soldToPartyCodes
   * @param directCodes
   * @return
   */
  List<InvoiceAcceptanceGoodsEntity> findAcceptanceByConditions(@Param("goodsCodes") List<String> goodsCodes,@Param("storeCodes") List<String> storeCodes,@Param("orderCodes") List<String> orderCodes,@Param("beginDate")String beginDate,@Param("endDate")String endDate,@Param("soldToPartyCodes") List<String> soldToPartyCodes,@Param("directCodes") List<String> directCodes);

  /**
   * 根据条件查询单据包含转换失败
   *
   * @param goodsCodes
   * @param storeCodes
   * @param orderCodes
   * @param beginDate
   * @param endDate
   * @param soldToPartyCodes
   * @param directCodes
   * @return
   */
  List<InvoiceAcceptanceGoodsVo> findAllByConditions(@Param("goodsCodes") List<String> goodsCodes,@Param("storeCodes") List<String> storeCodes,@Param("orderCodes") List<String> orderCodes,@Param("beginDate")String beginDate,@Param("endDate")String endDate,@Param("soldToPartyCodes") List<String> soldToPartyCodes,@Param("directCodes") List<String> directCodes);

  /**
   * 根据采购单号稽核或验收单号稽核查询数据
   * @param orderNumbers
   * @param relationKaOrderNumber
   * @param tenantCode
   * @return
   */
  List<InvoiceAcceptanceGoodsVo> findByOrderNumberOrRelationKaOrderNumber(@Param("orderNumbers") List<String> orderNumbers,@Param("relationKaOrderNumber") List<String> relationKaOrderNumber,@Param("tenantCode") String tenantCode);
}

