package com.biz.crm.kms.business.invoice.acceptance.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 验收单表(InvoiceAcceptance)表数据库访问层
 *
 * @author pengxi
 * @date 2022/10/10
 */
public interface InvoiceAcceptanceMapper extends BaseMapper<InvoiceAcceptanceEntity> {

    /**
     * 根据系统编码分页查询数据
     * @param page
     * @param tenantCode
     * @param directCodes
     * @return
     */
    Page<InvoiceAcceptanceVo> findAcceptanceByDirectCodes(Page<InvoiceAcceptanceVo> page, @Param("tenantCode") String tenantCode, @Param("directCodes") List<String> directCodes);

    /**
     * 条件查询验收单
     * @param beginDate
     * @param endDate
     * @param directCodes
     * @param tenantCode
     * @return
     */
    List<InvoiceAcceptanceVo> findAcceptanceOrderVo(@Param("beginDate") String beginDate,
                                                    @Param("endDate") String endDate,
                                                    @Param("directCodes") List<String> directCodes,
                                                    @Param("tenantCode") String tenantCode);
}

