package com.biz.crm.kms.business.invoice.acceptance.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGoodsGrabEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGrabEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.mapper.KmsInvoiceAcceptanceGoodsGrabMapper;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 验收单原始单据详情(repository)
 *
 * @author xi.peng
 * @since 2022-10-13 17:49:05
 */
@Component
public class KmsInvoiceAcceptanceGoodsGrabRepository extends ServiceImpl<KmsInvoiceAcceptanceGoodsGrabMapper, KmsInvoiceAcceptanceGoodsGrabEntity> {

  /**
   * 根据企业验收单编号获取验收单详情集合
   *
   * @param orderNumber 系统编码
   * @param tenantCode 租户编码
   * @return
   */
  public List<KmsInvoiceAcceptanceGoodsGrabEntity> findByOrderNumber(String orderNumber, String tenantCode) {
    return this.lambdaQuery()
        .eq(KmsInvoiceAcceptanceGoodsGrabEntity::getTenantCode, tenantCode)
        .eq(KmsInvoiceAcceptanceGoodsGrabEntity::getOrderNumber, orderNumber)
        .list();
  }

  /**
   * 根据企业验收单编号集合获取验收单详情集合
   *
   * @param orderNumbers 系统编码集合
   * @param tenantCode 租户编码
   * @return
   */
  public List<KmsInvoiceAcceptanceGoodsGrabEntity> findByOrderNumbers(List<String> orderNumbers, String tenantCode) {
    return this.lambdaQuery()
        .eq(KmsInvoiceAcceptanceGoodsGrabEntity::getTenantCode, tenantCode)
        .in(KmsInvoiceAcceptanceGoodsGrabEntity::getOrderNumber, orderNumbers)
        .list();
  }

  /**
   * 更新单据状态
   * @param tenantCode
   * @param transStatus
   * @param orderNumberList
   */
  public void updateTransStatusByOrderNumberList(String tenantCode, GrabTransStatus transStatus, List<String> orderNumberList) {
    if (StringUtils.isBlank(tenantCode)
            || Objects.isNull(transStatus)
            || CollectionUtil.isEmpty(orderNumberList)) {
      return;
    }
    this.lambdaUpdate()
            .eq(KmsInvoiceAcceptanceGoodsGrabEntity::getTenantCode, tenantCode)
            .in(KmsInvoiceAcceptanceGoodsGrabEntity::getOrderNumber, orderNumberList)
            .set(KmsInvoiceAcceptanceGoodsGrabEntity::getTransStatus, transStatus.getDictCode())
            .update();
  }

}
