package com.biz.crm.kms.business.invoice.acceptance.local.service;

import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import java.util.Date;
import java.util.List;

/**
 * 验收单原始单据详情(InvoiceAcceptanceGoodsGrab)表服务接口
 *
 * @author pengxi
 * @date 2022/10/10
 */
public interface InvoiceAcceptanceGoodsService {

  /**
   * 按验收单号查询选项列表
   *
   * @param orderNumber 验收单号
   * @return InvoiceAcceptanceGoodsEntity
   */
  List<InvoiceAcceptanceGoodsEntity> findByOrderNumber(String orderNumber);

  /**
   * 批量创建
   *
   * @param entities
   */
  void createBatch(List<InvoiceAcceptanceGoodsEntity> entities);

  /**
   * 根据商超验收单号删除
   *
   * @param kaOrderNumber 商超验收单号
   */
  void deleteByKaOrderNumber(String kaOrderNumber);

  /**
   * 根据多条件查询数据
   *
   * @param invoiceDates   单据日期
   * @param goodsCodes     商品编码
   * @param storeCodes     门店编码
   * @param kaOrderNumbers 商超订单编码
   * @return 数据集合
   */
  List<InvoiceAcceptanceGoodsEntity> findInvoiceStatistics(List<Date> invoiceDates, List<String> goodsCodes, List<String> storeCodes, List<String> kaOrderNumbers);

}
