package com.biz.crm.kms.business.invoice.acceptance.local.service;

import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGrabEntity;

import java.util.List;

/**
 * 验收单转换服务类
 * @author cyj
 * @version 1.0
 * @date 2022/11/24 17:00
 * @description InvoiceAcceptanceGrabService
 */
public interface InvoiceAcceptanceGrabService {

    /**
     * 验收单自动解析定时任务
     */
    void autoFailConvertAcceptanceOrder();

    /**
     * 验收单自动解析定时任务
     */
    void autoNotConvertAcceptanceOrder();


    /**
     * 转换
     *
     * @param orderNumberList 验收单号集合
     */
    void manualSwitch(List<String> orderNumberList);

    /**
     * 验收单商超门店和商超产品转换
     *
     * @param entityList
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.14 14:58
     */
    void convertOrder(List<InvoiceAcceptanceEntity> entityList);



    /**
     * 过滤正在转换的验收单号
     *
     * @param orderNumberList 验收单号集合
     * @return java.util.List<java.lang.String>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.14 1:45
     */
    void filterSwitchIngOrderNumberList(List<String> orderNumberList);

    /**
     * 零售商验收单导入保存
     * @param kmsInvoiceAcceptanceGrabEntities
     */
    void importSave(List<KmsInvoiceAcceptanceGrabEntity> kmsInvoiceAcceptanceGrabEntities);
}
