package com.biz.crm.kms.business.invoice.acceptance.local.service;

import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;

import java.util.List;

/**
 * 验收单表(InvoiceAcceptance)表服务接口
 *
 * @author pengxi
 * @date 2022/10/10
 */
public interface InvoiceAcceptanceService {

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  InvoiceAcceptanceEntity findDetailById(String id);

  /**
   * 转换
   * 该方法核心功能是把待转换抓单记录匹配出对应的商品及单位信息，写入转换后的验收单表
   * 其中注意事项：
   * 1、锁单逻辑：kms_invoice_acceptance表中如果已经存在order_number记录，则走更新逻辑，不新增记录
   * 2、转换过程主表与详情表的维护关系待思考确定一个最佳方案
   *
   * @param entity
   * @return
   */
  void transformation(InvoiceAcceptanceEntity entity);

  /**
   * 根据验收单id批量删除
   * @param ids
   */
  void deleteByIds(List<String> ids);

  /**
   * 新增数据
   * @param invoiceAcceptanceEntity
   * @return
   */
  InvoiceAcceptanceEntity create(InvoiceAcceptanceEntity invoiceAcceptanceEntity);
}
