package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceGoodsRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGoodsService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 验收单原始单据详情(InvoiceAcceptanceGoods)表服务实现类
 *
 * @author pengxi
 * @date 2022/10/10
 */
@Slf4j
@Service
public class InvoiceAcceptanceGoodsServiceImpl implements InvoiceAcceptanceGoodsService {

  @Autowired(required = false)
  private InvoiceAcceptanceGoodsRepository invoiceAcceptanceGoodsRepository;

  @Override
  public List<InvoiceAcceptanceGoodsEntity> findByOrderNumber(String orderNumber) {
    if (StringUtils.isBlank(orderNumber)) {
      return null;
    }
    return this.invoiceAcceptanceGoodsRepository.findByOrderNumber(TenantUtils.getTenantCode(), orderNumber);
  }

  @Override
  @Transactional
  public void createBatch(List<InvoiceAcceptanceGoodsEntity> entities) {
    this.invoiceAcceptanceGoodsRepository.saveBatch(entities);
  }

  @Override
  @Transactional
  public void deleteByKaOrderNumber(String kaOrderNumber) {
    Validate.notEmpty(kaOrderNumber, "商超验收单号不能为空！");
    this.invoiceAcceptanceGoodsRepository.deleteByKaOrderNumber(TenantUtils.getTenantCode(), kaOrderNumber);
  }

  /**
   * 根据多条件查询数据
   *
   * @param invoiceDates   单据日期
   * @param goodsCodes     商品编码
   * @param storeCodes     门店编码
   * @param kaOrderNumbers 商超订单编码
   * @return 数据集合
   */
  @Override
  public List<InvoiceAcceptanceGoodsEntity> findInvoiceStatistics(List<Date> invoiceDates, List<String> goodsCodes, List<String> storeCodes, List<String> kaOrderNumbers) {
    return this.invoiceAcceptanceGoodsRepository.findInvoiceStatistics(invoiceDates, goodsCodes, storeCodes, kaOrderNumbers);
  }
}
