package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGoodsService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceOrderGoodsImportsService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceOrderImportsService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceGoodsDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceOrderGoodsLogEventDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceOrderLogEventDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.event.InvoiceAcceptanceOrderGoodsLogEventListener;
import com.biz.crm.kms.business.invoice.acceptance.sdk.event.InvoiceAcceptanceOrderLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @Class InvoiceAcceptanceOrderImportsServiceImpl
 * @Description
 * @Author : cyj
 * @Date: 2022/11/28 16:15
 */
@Service
@Slf4j
public class InvoiceAcceptanceOrderGoodsImportsServiceImpl implements InvoiceAcceptanceOrderGoodsImportsService {

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private InvoiceAcceptanceGoodsService invoiceAcceptanceGoodsService;

    /**
     * 导入保存
     * @param list
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void importsSave(List<InvoiceAcceptanceGoodsEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(aa ->{
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
        });
        this.invoiceAcceptanceGoodsService.createBatch(list);

        Collection<InvoiceAcceptanceGoodsDto> invoiceAcceptanceGoodsDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list,InvoiceAcceptanceGoodsEntity.class,InvoiceAcceptanceGoodsDto.class, LinkedHashSet.class, ArrayList.class);
        // 业务日志创建
        invoiceAcceptanceGoodsDtos.forEach(dto -> {
            InvoiceAcceptanceOrderGoodsLogEventDto logEventDto = new InvoiceAcceptanceOrderGoodsLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<InvoiceAcceptanceOrderGoodsLogEventListener, InvoiceAcceptanceOrderGoodsLogEventDto> onCreate =
                    InvoiceAcceptanceOrderGoodsLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, InvoiceAcceptanceOrderGoodsLogEventListener.class, onCreate);
        });
    }
}
