package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceOrderImportsService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceOrderLogEventDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.event.InvoiceAcceptanceOrderLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @Class InvoiceAcceptanceOrderImportsServiceImpl
 * @Description
 * @Author : cyj
 * @Date: 2022/11/28 16:15
 */
@Service
@Slf4j
public class InvoiceAcceptanceOrderImportsServiceImpl implements InvoiceAcceptanceOrderImportsService {

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private InvoiceAcceptanceService invoiceAcceptanceService;

    /**
     * 导入保存
     * @param list
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void importsSave(List<InvoiceAcceptanceEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        log.info("收到验收单数据");
        list.forEach(aa ->{
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
            //数据来源说明
            aa.setInvoicesSource("手动导入");
            log.info("开始保存={}", JSON.toJSONString(aa));
            this.invoiceAcceptanceService.create(aa);
        });
        log.info("开始保存日志");
        Collection<InvoiceAcceptanceDto> invoiceAcceptanceDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list,InvoiceAcceptanceEntity.class,InvoiceAcceptanceDto.class, LinkedHashSet.class, ArrayList.class);
        // 业务日志创建
        invoiceAcceptanceDtos.forEach(dto -> {
            InvoiceAcceptanceOrderLogEventDto logEventDto = new InvoiceAcceptanceOrderLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<InvoiceAcceptanceOrderLogEventListener, InvoiceAcceptanceOrderLogEventDto> onCreate =
                    InvoiceAcceptanceOrderLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, InvoiceAcceptanceOrderLogEventListener.class, onCreate);
        });
    }
}
