package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.biz.crm.kms.business.invoice.acceptance.local.entity.SapAcceptanceTestEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.SapResultTestEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.mapper.InvoiceAcceptanceTestMapper;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceTestService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 验收单表(InvoiceAcceptance)表服务实现类
 *
 * @author pengxi
 * @date 2022/10/10
 */
@Slf4j
@Service
public class InvoiceAcceptanceTestServiceImpl implements InvoiceAcceptanceTestService {

    @Autowired(required = false)
    private InvoiceAcceptanceTestMapper testMapper;


    @Override
    public void auditTest() {
        List<SapAcceptanceTestEntity> acceptanceVoList = testMapper.acceptanceVoList("");
        List<SapResultTestEntity> sapResultTestEntityList = testMapper.sapResultVoList("");
        Map<String, String> acceptanceMap = new HashMap<>(acceptanceVoList.size());
        /**
         * 2022-09-02  -  2022-09-30
         * ①重庆家美佳  6176   CQMN0001
         * 匹配条件
         * 日期：取SAP发货过账日期和   商超验收单入库日期   时间（T-1 到 T+3）
         * 产品：物料编码、描述对应  商超验收单产品编码名称
         * 数量：交货单数量   对应  验收数量
         * 金额：SAP交货单折前金额   对应 单据验收金额
         */
        test(acceptanceVoList, sapResultTestEntityList, acceptanceMap, "CQMN0001", false, -1, 3);
        log.error("匹配完成A => directCode[{}]", "CQMN0001");
        /**
         * 2022-08-01 2022-09-08
         * ②安徽百大合家福   6166   HFMN0001
         * 匹配条件
         * 日期：取发货过账日期和   商超验收单  验收日期   时间（T+5）
         * 门店：送达方编码名称对应门店编码名称
         * 产品：物料编码、描述对应  商超验收单产品编码名称
         * 数量：交货单数量   对应  验收数量
         * 金额：SAP交货单折前金额   对应 单据验收金额
         */
        test(acceptanceVoList, sapResultTestEntityList, acceptanceMap, "HFMN0001", true, 0, 5);
        log.error("匹配完成B => directCode[{}]", "HFMN0001");
        /**
         * 2022-10-01  2022-11-05
         * ③济南银座   6172   JNMN0003
         * 匹配条件
         * 日期：取交货日期和 商超验收单验收日期  时间T+10
         * 门店：送达方编码名称对应门店编码名称
         * 产品：物料编码、描述对应  商超验收单产品编码名称
         * 数量：交货单数量   对应  验收数量
         * 金额：SAP交货单折前金额   对应 单据验收金额
         */
        test(acceptanceVoList, sapResultTestEntityList, acceptanceMap, "JNMN0003", true, 0, 10);

        log.error("匹配完成C => directCode[{}]", "JNMN0003");
    }


    /**
     * @param directCode 系统编码
     * @param beginDay   匹配的单据开始T
     * @param endDay     匹配的单据结束T
     */
    private void test(List<SapAcceptanceTestEntity> acceptanceVoList,
                      List<SapResultTestEntity> sapResultTestEntityList,
                      Map<String, String> acceptanceMap,
                      String directCode, boolean isTerminal, int beginDay, int endDay) {
        List<SapAcceptanceTestEntity> acceptanceDirectList = acceptanceVoList.stream()
                .filter(k -> directCode.equals(k.getDirectCode()))
                .collect(Collectors.toList());
        sapResultTestEntityList.forEach(sap -> {
            for (int j = beginDay; j <= endDay; j++) {
                int finalJ = j;
                acceptanceDirectList
                        .forEach(acc -> {
                            boolean flag = true;
                            long betweenDays = (acc.getOrderTime().getTime() - sap.getSapTime().getTime()) / (1000 * 3600 * 24);
                            if (finalJ == betweenDays) {

                            } else {
                                flag = false;
                            }

                            if (sap.getProductCode().equals(acc.getProductCode())) {

                            } else {
                                flag = false;
                            }

//                            if (sap.getSapQuantity().compareTo(acc.getQuantity()) == 0) {
//
//                            } else {
//                                flag = false;
//                            }
                            if (!"CQMN0001".equals(acc.getDirectCode())) {
                                if (sap.getStoreCode().equals(acc.getStoreCode())) {

                                } else {
                                    flag = false;
                                }

                            }
                            if (flag) {
                                if (!acceptanceMap.containsKey(acc.getOrderNo())
                                        || sap.getSapNo().equals(acceptanceMap.get(acc.getOrderNo()))) {
                                    acceptanceMap.put(acc.getOrderNo(), sap.getSapNo());
                                    sap.setOrderNo(acc.getOrderNo());
                                    sap.setOrderTime(acc.getOrderTime());
                                    sap.setDirectCode(acc.getDirectCode());
                                    sap.setOrderStoreCode(acc.getStoreCode());
                                    sap.setOrderProductCode(acc.getProductCode());
                                    sap.setOrderAmount(acc.getAmount());
                                    sap.setOrderQuantity(acc.getQuantity());
                                    testMapper.updateById(sap);
                                }
                            }
                        });
            }
        });

    }
}
