package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGrabService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 验收单抓取数据(python)后自动转换     job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class InvoiceAcceptanceXxlJob {


    @Autowired(required = false)
    private InvoiceAcceptanceGrabService invoiceAcceptanceGrabService;

    /**
     * 定时任务自动转换验收单
     */
    @DynamicTaskService(cornExpression = "0 0/10 * * * ?", taskDesc = "验收单未转换单据自动转换定时任务")
    public void convertNotAcceptanceOrderTask() {
        //TODO  需要改成  定时任务分片+redis锁
        invoiceAcceptanceGrabService.autoNotConvertAcceptanceOrder();
    }
    /**
     * 定时任务自动转换验收单
     */
    @DynamicTaskService(cornExpression = "0 0 2/2 * * ?", taskDesc = "验收单转换失败单据自动转换定时任务")
    public void convertFailAcceptanceOrderTask() {
        //TODO  需要改成  定时任务分片+redis锁
        invoiceAcceptanceGrabService.autoFailConvertAcceptanceOrder();
    }

}
