package com.biz.crm.kms.business.invoice.acceptance.local.service.notifier;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.register.AcceptanceInvoiceTypeRegister;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceGoodsRepository;
import com.biz.crm.kms.business.invoice.sdk.strategy.InvoiceStatisticsStrategy;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceStatisticsVo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @author songjingen
 * @date 2022/11/3 15:20
 */
@Component
public class AcceptanceStatisticsStrategy implements InvoiceStatisticsStrategy {

  @Autowired(required = false)
  private AcceptanceInvoiceTypeRegister acceptanceInvoiceTypeRegister;

  @Autowired(required = false)
  private InvoiceAcceptanceGoodsRepository invoiceAcceptanceGoodsRepository;

  @Override
  public String getType() {
    return this.acceptanceInvoiceTypeRegister.type();
  }

  @Override
  public List<InvoiceStatisticsVo> findInvoiceStatistics(List<Date> invoiceDates, List<String> goodsCodes, List<String> storeCodes, List<String> kaOrderNumbers, List... args) {
    if (CollectionUtils.isEmpty(goodsCodes) || CollectionUtils.isEmpty(storeCodes)) {
      return new ArrayList<>(0);
    }
    List<InvoiceAcceptanceGoodsEntity> invoiceStatistics = this.invoiceAcceptanceGoodsRepository.findInvoiceStatistics(invoiceDates, goodsCodes, storeCodes, kaOrderNumbers);
    if (CollectionUtils.isEmpty(invoiceStatistics)) {
      return new ArrayList<>(0);
    }
    return this.covertToInvoiceStatisticsVo(invoiceStatistics);
  }

  @Override
  public List<InvoiceStatisticsVo> findByConditions(String type, List<String> goodsCodes, List<String> storeCodes, List<String> orderCodes, String beginDate,String endDate, List<String> soldToPartyCode, List<String> directCodes) {
    if (CollectionUtils.isEmpty(goodsCodes) && CollectionUtils.isEmpty(soldToPartyCode) && CollectionUtils.isEmpty(directCodes)) {
      return new ArrayList<>(0);
    }
    List<InvoiceAcceptanceGoodsEntity> invoiceStatistics = this.invoiceAcceptanceGoodsRepository.findAcceptanceByConditions(goodsCodes,storeCodes,orderCodes,beginDate,endDate,soldToPartyCode,directCodes);
    if (CollectionUtils.isEmpty(invoiceStatistics)) {
      return new ArrayList<>(0);
    }
    return this.covertToInvoiceStatisticsVo(invoiceStatistics);
  }

  @Override
  public List<InvoiceStatisticsVo> findByInvoiceCodes(List<String> invoiceCodes) {
    if (CollectionUtils.isEmpty(invoiceCodes)) {
      return new ArrayList<>(0);
    }
    List<InvoiceAcceptanceGoodsEntity> invoiceStatistics = this.invoiceAcceptanceGoodsRepository.findByIds(invoiceCodes);
    if (CollectionUtils.isEmpty(invoiceStatistics)) {
      return new ArrayList<>(0);
    }
    return this.covertToInvoiceStatisticsVo(invoiceStatistics);
  }

  @Override
  public List<InvoiceStatisticsVo> findByRelationId(List<String> relationIds) {
    if (CollectionUtils.isEmpty(relationIds)) {
      return new ArrayList<>(0);
    }
    List<InvoiceAcceptanceGoodsEntity> invoiceStatistics = this.invoiceAcceptanceGoodsRepository.findByRelationId(relationIds);
    if (CollectionUtils.isEmpty(invoiceStatistics)) {
      return new ArrayList<>(0);
    }
    return this.covertToInvoiceStatisticsVo(invoiceStatistics);
  }

  @Override
  public List<InvoiceStatisticsVo> findCrossByConditions(List<String> relationKaOrderCodes, List<String> acceptanceOrderNumber) {
    if (CollectionUtils.isEmpty(relationKaOrderCodes) && CollectionUtils.isEmpty(acceptanceOrderNumber)) {
      return new ArrayList<>(0);
    }
    List<InvoiceAcceptanceGoodsEntity> invoiceStatistics = this.invoiceAcceptanceGoodsRepository.findCrossByConditions(relationKaOrderCodes,acceptanceOrderNumber);
    if (CollectionUtils.isEmpty(invoiceStatistics)) {
      return new ArrayList<>(0);
    }
    return this.covertToInvoiceStatisticsVo(invoiceStatistics);
  }

  private List<InvoiceStatisticsVo> covertToInvoiceStatisticsVo(List<InvoiceAcceptanceGoodsEntity> invoiceStatistics) {
    List<InvoiceStatisticsVo> vos = new ArrayList<>();
    for (InvoiceAcceptanceGoodsEntity goodsEntity : invoiceStatistics) {
      InvoiceStatisticsVo vo = new InvoiceStatisticsVo();
      vo.setInvoiceType(this.getType());
      vo.setInvoiceAmount(goodsEntity.getAcceptanceAmount() != null ? goodsEntity.getAcceptanceAmount():BigDecimal.ZERO);
      vo.setInvoiceAmountTaxExclusive(goodsEntity.getAcceptanceAmountNot() != null ? goodsEntity.getAcceptanceAmountNot():BigDecimal.ZERO);
      vo.setOrderNumber(goodsEntity.getOrderNumber());
      vo.setKaOrderNumber(goodsEntity.getKaOrderNumber());
      vo.setInvoiceCode(goodsEntity.getId());
      vo.setInvoiceDate(DateUtil.parse(goodsEntity.getAcceptanceDate(), "yyyy-MM-dd"));
      vo.setStoreCode(goodsEntity.getStoreCode());
      vo.setGoodsCode(goodsEntity.getGoodsCode());
      vo.setGoodsName(goodsEntity.getGoodsName());
      vo.setInvoiceCount(goodsEntity.getCurCompanyUnitOrderQuantity() != null ? goodsEntity.getCurCompanyUnitOrderQuantity():BigDecimal.ZERO);
      vo.setOrderCode(goodsEntity.getRelateKaOrderNumber());
      vo.setSoldToPartyCode(goodsEntity.getSoldToPartyCode());
      vo.setSuperMarketCode(goodsEntity.getKaCode());
      vo.setOrderStatus(goodsEntity.getOrderStatus());
      vo.setOrderStatusMsg(goodsEntity.getOrderStatusMsg());
      //计算单价
      if (vo.getInvoiceCount().compareTo(BigDecimal.ZERO) != 0){
        vo.setInvoicePrice(vo.getInvoiceAmount().divide(vo.getInvoiceCount(), 4,BigDecimal.ROUND_HALF_UP));
        vo.setInvoicePriceNoTax(vo.getInvoiceAmountTaxExclusive().divide(vo.getInvoiceCount(),4,BigDecimal.ROUND_HALF_UP));
      }else {
        vo.setInvoicePrice(BigDecimal.ZERO);
      }
      vos.add(vo);
    }
    return vos;
  }
}
