package com.biz.crm.kms.business.invoice.acceptance.local.views;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @Class AcceptanceGoodsDataViewRegister
 * @Description KMS验收单明细数据视图
 * @Author : ZS
 * @Date: 2023/3/2  11:14
 */
@Component
public class AcceptanceGoodsDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "kms_acceptance_goods_data_view";
    }

    @Override
    public String desc() {
        return "KMS验收单明细数据视图";
    }

    @Override
    public String buildSql() {
        return  "SELECT t.* FROM kms_invoice_acceptance_goods t " +
                "WHERE t.tenant_code = :tenantCode " +
                "AND t.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
