/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGrabService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.service.InvoiceAcceptanceVoService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9a8c\u6536\u5355\u8868\uff1aInvoiceAcceptanceVo\uff1a\u9a8c\u6536\u5355"})
@RestController
@RequestMapping(value={"/v1/invoiceAcceptance/invoiceAcceptanceVo"})
public class InvoiceAcceptanceVoController {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceVoController.class);
    @Autowired(required=false)
    private InvoiceAcceptanceVoService invoiceAcceptanceVoService;
    @Autowired(required=false)
    private InvoiceAcceptanceService invoiceAcceptanceService;
    @Autowired(required=false)
    private InvoiceAcceptanceGrabService invoiceAcceptanceGrabService;

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<InvoiceAcceptanceVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            InvoiceAcceptanceVo vo = this.invoiceAcceptanceVoService.findDetailById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7ed3\u7b97\u5355\u7684\u9a8c\u6536\u5355\u8be6\u60c5")
    @GetMapping(value={"/findByDecomentCode"})
    public Result<InvoiceAcceptanceVo> findByDecomentCode(String code, String deliveryPartyCode) {
        try {
            InvoiceAcceptanceVo vo = this.invoiceAcceptanceVoService.findByDecomentCode(code, deliveryPartyCode);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u8f6c\u6362")
    @PatchMapping(value={"/manualSwitch"})
    public Result<?> manualSwitch(@RequestBody List<String> ids) {
        try {
            this.invoiceAcceptanceVoService.manualSwitch(ids);
            return Result.ok((String)"\u8f6c\u6362\u7ed3\u675f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5b9a\u65f6\u4efb\u52a1")
    @GetMapping
    public void autoJob() {
        this.invoiceAcceptanceGrabService.autoNotConvertAcceptanceOrder();
    }

    @DeleteMapping
    @ApiOperation(value="\u9a8c\u6536\u5355\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.invoiceAcceptanceService.deleteByIds(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<InvoiceAcceptanceEntity> create(@ApiParam(name="InvoiceAcceptanceEntity", value="") @RequestBody InvoiceAcceptanceEntity invoiceAcceptanceEntity) {
        try {
            InvoiceAcceptanceEntity result = this.invoiceAcceptanceService.create(invoiceAcceptanceEntity);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62c6\u5206\u9a8c\u6536\u5355")
    @PostMapping(value={"/splitAcceptance"})
    public Result<?> splitAcceptance(@RequestBody List<InvoiceAcceptanceVo> invoiceAcceptanceVos) {
        try {
            this.invoiceAcceptanceVoService.splitAcceptance(invoiceAcceptanceVos);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u64a4\u9500\u62c6\u5206\u9a8c\u6536\u5355")
    @GetMapping(value={"/withdrawSplit"})
    public Result<?> withdrawSplit(String id) {
        try {
            this.invoiceAcceptanceVoService.withdrawSplit(id);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

