/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.business.invoice.acceptance.local.exports.dto.InvoiceAcceptenceExportDto;
import com.biz.crm.kms.business.invoice.acceptance.local.exports.mapper.InvoiceAcceptanceExportMapper;
import com.biz.crm.kms.business.invoice.acceptance.local.exports.vo.InvoiceAcceptenceExportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceAcceptanceExportProcess
implements ExportProcess<InvoiceAcceptenceExportVo> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceExportProcess.class);
    @Autowired(required=false)
    private InvoiceAcceptanceExportMapper invoiceAcceptanceExportMapper;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private RedisService redisService;

    public Integer getPageSize() {
        return 50000;
    }

    public Integer getTotal(Map<String, Object> params) {
        InvoiceAcceptenceExportDto dto = this.convertParams(params);
        Page<InvoiceAcceptenceExportVo> pageResult = this.invoiceAcceptanceExportMapper.findByConditions((Page<InvoiceAcceptenceExportDto>)new Page(0L, 1L), dto);
        log.info("\u9a8c\u6536\u5355\u83b7\u53d6\u5230\u7684\u603b\u6570\u91cf\u4e3a{}", (Object)pageResult.getTotal());
        return (int)pageResult.getTotal();
    }

    public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
        if (processVo.getPageNo() == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        processVo.setPageNo(Integer.valueOf(processVo.getPageNo() + 1));
        InvoiceAcceptenceExportDto dto = this.convertParams(params);
        log.info("\u9a8c\u6536\u5355\u5206\u9875\u9875\u6570\u4e3a{}\uff0c\u6761\u6570\u4e3a{}", (Object)processVo.getPageNo(), (Object)processVo.getPageSize());
        Page pageable = new Page((long)processVo.getPageNo().intValue(), (long)this.getPageSize().intValue());
        Object o = this.redisService.get("KMS:CACHE:PRODUCT_TAX_RATE");
        Map productTaxMap = (Map)o;
        log.info("\u9a8c\u6536\u5355\u5206\u9875\u9875\u6570\u4e3a{}\uff0c\u6761\u6570\u4e3a{}", (Object)pageable.getCurrent(), (Object)pageable.getSize());
        Page<InvoiceAcceptenceExportVo> page = this.invoiceAcceptanceExportMapper.findByConditions((Page<InvoiceAcceptenceExportDto>)pageable, dto);
        this.buildVo(page.getRecords(), productTaxMap);
        return JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()));
    }

    public Class<InvoiceAcceptenceExportVo> findCrmExcelVoClass() {
        return InvoiceAcceptenceExportVo.class;
    }

    public String getBusinessCode() {
        return "KMS_INVOICE_ACCEPTANCE_EXPORT";
    }

    public String getBusinessName() {
        return "KMS\u5355\u636e-\u9a8c\u6536\u5355\u5bfc\u51fa";
    }

    private InvoiceAcceptenceExportDto convertParams(Map<String, Object> params) {
        params.remove("sort");
        params.remove("europaInfoCode");
        Map<String, Object> map = params.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf("_")), Map.Entry::getValue, (a, b) -> a));
        ArrayList dateList = new ArrayList();
        params.forEach((k, v) -> {
            if (k.contains("acceptance_time")) {
                dateList.add(v.toString());
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dateList)) {
            Collections.sort(dateList);
            if (dateList.size() > 1) {
                map.put("beginDate", dateList.get(0));
                map.put("endDate", dateList.get(1));
            }
        }
        InvoiceAcceptenceExportDto dto = (InvoiceAcceptenceExportDto)((Object)JSON.parseObject((String)JSON.toJSONString(map), InvoiceAcceptenceExportDto.class));
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return dto;
    }

    private void buildVo(List<InvoiceAcceptenceExportVo> page, Map<String, BigDecimal> productTaxMap) {
        if (CollectionUtils.isEmpty(page)) {
            return;
        }
        Map<Object, Object> businessFormatMap = new HashMap();
        Map<Object, Object> businessUnitMap = new HashMap();
        Map<Object, Object> bussinessAreaMap = new HashMap();
        Map<Object, Object> orderStatusMap = new HashMap();
        List businessFormat = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        List businessUnit = this.dictDataVoService.findByDictTypeCode("mdm_business_unit");
        List bussinessArea = this.dictDataVoService.findByDictTypeCode("MDM_CUSTOMIZE_ORG");
        List orderStatus = this.dictDataVoService.findByDictTypeCode("kms_order_status");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)businessFormat)) {
            businessFormatMap = businessFormat.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)businessUnit)) {
            businessUnitMap = businessUnit.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)bussinessArea)) {
            bussinessAreaMap = bussinessArea.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderStatus)) {
            orderStatusMap = orderStatus.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        for (InvoiceAcceptenceExportVo invoiceAcceptenceExportVo : page) {
            invoiceAcceptenceExportVo.setBusinessUnitCode((String)businessUnitMap.get(invoiceAcceptenceExportVo.getBusinessUnitCode()));
            invoiceAcceptenceExportVo.setBusinessFormatCode((String)businessFormatMap.get(invoiceAcceptenceExportVo.getBusinessFormatCode()));
            invoiceAcceptenceExportVo.setBusinessArea((String)bussinessAreaMap.get(invoiceAcceptenceExportVo.getBusinessArea()));
            invoiceAcceptenceExportVo.setOrderStatus((String)orderStatusMap.get(invoiceAcceptenceExportVo.getOrderStatus()));
            invoiceAcceptenceExportVo.setGoodsOrderStatus((String)orderStatusMap.get(invoiceAcceptenceExportVo.getGoodsOrderStatus()));
            if (!Objects.nonNull(productTaxMap) || !Objects.nonNull(productTaxMap.get(invoiceAcceptenceExportVo.getGoodsCode()))) continue;
            invoiceAcceptenceExportVo.setRax(productTaxMap.get(invoiceAcceptenceExportVo.getGoodsCode()));
        }
    }
}

