/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.imports.service;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGoodsGrabEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGrabEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.imports.model.InvoiceAcceptanceOrderImportsVo;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGrabService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceOrderImportsService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceAcceptanceOrderImportsProcess
implements ImportProcess<InvoiceAcceptanceOrderImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceOrderImportsProcess.class);
    @Autowired
    private InvoiceAcceptanceOrderImportsService importSave;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private InvoiceAcceptanceGrabService invoiceAcceptanceGrabService;

    public Integer getBatchCount() {
        return 10000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, InvoiceAcceptanceOrderImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(data.values())) {
            return Maps.newHashMap();
        }
        log.info("\u6570\u636e\uff1a{}", data.values());
        HashMap importMap = Maps.newHashMap();
        List fomatList = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        HashMap fomatMap = Maps.newHashMap();
        for (DictDataVo vo : fomatList) {
            fomatMap.put(vo.getDictValue(), vo.getDictCode());
        }
        List unitList = this.dictDataVoService.findByDictTypeCode("mdm_business_unit");
        HashMap unitMap = Maps.newHashMap();
        for (DictDataVo vo : unitList) {
            unitMap.put(vo.getDictValue(), vo.getDictCode());
        }
        HashMap response = Maps.newHashMap();
        StringBuilder error = new StringBuilder();
        InvoiceAcceptanceEntity entity = new InvoiceAcceptanceEntity();
        InvoiceAcceptanceGoodsEntity goodsEntity = new InvoiceAcceptanceGoodsEntity();
        List<Object> goodsEntityList = Lists.newArrayList();
        for (Map.Entry<Integer, InvoiceAcceptanceOrderImportsVo> importVo : data.entrySet()) {
            Integer index = importVo.getKey();
            InvoiceAcceptanceOrderImportsVo vo = importVo.getValue();
            error = new StringBuilder();
            try {
                this.check(vo);
            }
            catch (Exception e) {
                error.append(e);
            }
            entity = importMap.get(vo.getKaOrderNumber()) == null ? (InvoiceAcceptanceEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, InvoiceAcceptanceEntity.class, HashSet.class, ArrayList.class, new String[0])) : (InvoiceAcceptanceEntity)((Object)importMap.get(vo.getKaOrderNumber()));
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setBusinessFormatCode((String)fomatMap.get(vo.getBusinessFormatCode()));
            entity.setBusinessUnitCode((String)unitMap.get(vo.getBusinessUnitCode()));
            if (StringUtils.isEmpty((CharSequence)entity.getOrderNumber())) {
                entity.setOrderNumber("YS" + System.currentTimeMillis());
            }
            goodsEntity = (InvoiceAcceptanceGoodsEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, InvoiceAcceptanceGoodsEntity.class, HashSet.class, ArrayList.class, new String[0]));
            goodsEntity.setTenantCode(TenantUtils.getTenantCode());
            goodsEntity.setOrderNumber(entity.getOrderNumber());
            try {
                this.goodsAmountTrans(vo, goodsEntity);
            }
            catch (Exception e) {
                error.append("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff1a" + e);
            }
            try {
                this.amountTotal(entity, goodsEntity);
            }
            catch (Exception e) {
                error.append("\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff1a" + e);
            }
            if (CollectionUtils.isEmpty(entity.getGoodsList())) {
                goodsEntityList = Lists.newArrayList();
                goodsEntityList.add((Object)goodsEntity);
                entity.setGoodsList(goodsEntityList);
            } else {
                goodsEntityList = entity.getGoodsList();
                goodsEntityList.add((Object)goodsEntity);
                entity.setGoodsList(goodsEntityList);
            }
            importMap.put(vo.getKaOrderNumber(), entity);
            if (error.length() <= 0) continue;
            response.put(index, error.toString());
        }
        ArrayList entityList = Lists.newArrayList();
        ArrayList<KmsInvoiceAcceptanceGrabEntity> grabEntityList = new ArrayList<KmsInvoiceAcceptanceGrabEntity>();
        for (InvoiceAcceptanceEntity acceptanceEntity : importMap.values()) {
            try {
                KmsInvoiceAcceptanceGrabEntity grabEntity = (KmsInvoiceAcceptanceGrabEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)acceptanceEntity, KmsInvoiceAcceptanceGrabEntity.class, HashSet.class, ArrayList.class, new String[0]));
                List grabGoods = (List)this.nebulaToolkitService.copyCollectionByWhiteList(acceptanceEntity.getGoodsList(), InvoiceAcceptanceGoodsEntity.class, KmsInvoiceAcceptanceGoodsGrabEntity.class, HashSet.class, ArrayList.class, new String[0]);
                grabEntity.setGoodsList(grabGoods);
                grabEntityList.add(grabEntity);
            }
            catch (Exception e) {
                log.error("\u9a8c\u6536\u5355\u539f\u59cb\u4fe1\u606f\u8f6c\u6362\u9519\u8bef={}", (Throwable)e);
            }
            entityList.add(acceptanceEntity);
        }
        log.info("\u5f00\u59cb\u4fdd\u5b58\u9a8c\u6536\u5355\u6570\u636e={}", (Object)JSON.toJSONString((Object)entityList));
        this.importSave.importsSave(entityList);
        log.info("\u5f00\u59cb\u4fdd\u5b58\u9a8c\u6536\u5355\u539f\u59cb\u6570\u636e={}", (Object)JSON.toJSONString(grabEntityList));
        this.invoiceAcceptanceGrabService.importSave(grabEntityList);
        return response;
    }

    private void check(InvoiceAcceptanceOrderImportsVo vo) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaOrderNumber()), (String)"\u96f6\u552e\u5546\u9a8c\u6536\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getRelateKaOrderNumber()), (String)"\u5173\u8054\u96f6\u552e\u5546\u91c7\u8d2d\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getDirectCode()), (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaName()), (String)"\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getBusinessFormatCode()), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaStoreCode()), (String)"\u96f6\u552e\u5546\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaStoreName()), (String)"\u96f6\u552e\u5546\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getAcceptanceDate()), (String)"\u9a8c\u6536\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaGoodsCode()), (String)"\u96f6\u552e\u5546\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaGoodsName()), (String)"\u96f6\u552e\u5546\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getAcceptanceOneAmountStr()), (String)"\u9a8c\u6536\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCurUnitAcceptanceQuantityStr()), (String)"\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)vo.getAcceptanceAmountNotStr()) || StringUtils.isNotBlank((CharSequence)vo.getAcceptanceAmountStr()) ? 1 : 0) != 0, (String)"\u9a8c\u6536\u91d1\u989d\u5c0f\u8ba1\uff08\u4e0d\u542b\u7a0e\uff09\u6216\u9a8c\u6536\u91d1\u989d\u5c0f\u8ba1\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void goodsAmountTrans(InvoiceAcceptanceOrderImportsVo vo, InvoiceAcceptanceGoodsEntity entity) {
        if (StringUtils.isNotBlank((CharSequence)vo.getAcceptanceOneAmountStr())) {
            BigDecimal acceptanceOneAmount = new BigDecimal(vo.getAcceptanceOneAmountStr());
            entity.setAcceptanceOneAmount(acceptanceOneAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getOrderQuantityStr())) {
            BigDecimal orderQuantity = new BigDecimal(vo.getOrderQuantityStr());
            entity.setOrderQuantity(orderQuantity);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getCurUnitAcceptanceQuantityStr())) {
            BigDecimal curUnitAcceptanceQuantity = new BigDecimal(vo.getCurUnitAcceptanceQuantityStr());
            entity.setCurUnitAcceptanceQuantity(curUnitAcceptanceQuantity);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getAcceptanceAmountNotStr())) {
            BigDecimal acceptanceAmountNot = new BigDecimal(vo.getAcceptanceAmountNotStr());
            entity.setAcceptanceAmountNot(acceptanceAmountNot);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getAcceptanceAmountStr())) {
            BigDecimal acceptanceAmount = new BigDecimal(vo.getAcceptanceAmountStr());
            entity.setAcceptanceAmount(acceptanceAmount);
        }
    }

    private void amountTotal(InvoiceAcceptanceEntity entity, InvoiceAcceptanceGoodsEntity goodsEntity) {
        BigDecimal finalAcceptanceAmount = BigDecimal.ZERO;
        BigDecimal finalAcceptanceAmountNot = BigDecimal.ZERO;
        if (entity.getFinalAcceptanceAmount() != null && entity.getFinalAcceptanceAmount().compareTo(BigDecimal.ZERO) != 0) {
            finalAcceptanceAmount = entity.getFinalAcceptanceAmount();
        }
        if (entity.getFinalAcceptanceAmountNot() != null && entity.getFinalAcceptanceAmountNot().compareTo(BigDecimal.ZERO) != 0) {
            finalAcceptanceAmountNot = entity.getFinalAcceptanceAmountNot();
        }
        if (goodsEntity.getAcceptanceAmount() != null) {
            finalAcceptanceAmount = finalAcceptanceAmount.add(goodsEntity.getAcceptanceAmount());
        }
        if (goodsEntity.getAcceptanceAmountNot() != null) {
            finalAcceptanceAmountNot = finalAcceptanceAmountNot.add(goodsEntity.getAcceptanceAmountNot());
        }
        entity.setFinalAcceptanceAmount(finalAcceptanceAmount);
        entity.setFinalAcceptanceAmountNot(finalAcceptanceAmountNot);
    }

    public Class<InvoiceAcceptanceOrderImportsVo> findCrmExcelVoClass() {
        return InvoiceAcceptanceOrderImportsVo.class;
    }

    public String getTemplateCode() {
        return "KMS_ACCEPTANCE_ORDER_IMPORT";
    }

    public String getTemplateName() {
        return "\u4f01\u4e1a\u9a8c\u6536\u5355\u5bfc\u5165";
    }
}

