/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.mapper.InvoiceAcceptanceGoodsMapper;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceGoodsVo;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class InvoiceAcceptanceGoodsRepository
extends ServiceImpl<InvoiceAcceptanceGoodsMapper, InvoiceAcceptanceGoodsEntity> {
    public List<InvoiceAcceptanceGoodsEntity> findByOrderNumber(String tenantCode, String orderNumber) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(InvoiceAcceptanceGoodsEntity::getOrderNumber, (Object)orderNumber)).list();
    }

    public void deleteByKaOrderNumber(String tenantCode, String kaOrderNumber) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(InvoiceAcceptanceGoodsEntity::getKaOrderNumber, (Object)kaOrderNumber)).remove();
    }

    public void deleteByKaOrderNumbers(String tenantCode, List<String> kaOrderNumbers) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(InvoiceAcceptanceGoodsEntity::getKaOrderNumber, kaOrderNumbers)).remove();
    }

    public List<InvoiceAcceptanceGoodsEntity> findInvoiceStatistics(List<Date> invoiceDates, List<String> goodsCodes, List<String> storeCodes, List<String> kaOrderNumbers) {
        return ((InvoiceAcceptanceGoodsMapper)this.baseMapper).findInvoiceStatistics(invoiceDates, goodsCodes, storeCodes, kaOrderNumbers);
    }

    public List<InvoiceAcceptanceGoodsEntity> findAcceptanceByConditions(List<String> goodsCodes, List<String> storeCodes, List<String> orderCodes, String beginDate, String endDate, List<String> soldToPartyCode, List<String> directCodes) {
        return ((InvoiceAcceptanceGoodsMapper)this.baseMapper).findAcceptanceByConditions(goodsCodes, storeCodes, orderCodes, beginDate, endDate, soldToPartyCode, directCodes);
    }

    public List<InvoiceAcceptanceGoodsVo> findAllByConditions(List<String> goodsCodes, List<String> storeCodes, List<String> orderCodes, String beginDate, String endDate, List<String> soldToPartyCodes, List<String> directCodes) {
        if (CollectionUtils.isEmpty(goodsCodes) && CollectionUtils.isEmpty(storeCodes) && CollectionUtils.isEmpty(orderCodes) && StringUtils.isEmpty((Object)beginDate) && StringUtils.isEmpty((Object)endDate) && CollectionUtils.isEmpty(soldToPartyCodes) && CollectionUtils.isEmpty(directCodes)) {
            return Lists.newArrayList();
        }
        return ((InvoiceAcceptanceGoodsMapper)this.baseMapper).findAllByConditions(goodsCodes, storeCodes, orderCodes, beginDate, endDate, soldToPartyCodes, directCodes);
    }

    public List<InvoiceAcceptanceGoodsEntity> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public List<InvoiceAcceptanceGoodsEntity> findByRelationId(List<String> relationIds) {
        return ((InvoiceAcceptanceGoodsMapper)this.baseMapper).findByRelationId(relationIds);
    }

    public List<InvoiceAcceptanceGoodsEntity> findCrossByConditions(List<String> relationKaOrderCodes, List<String> acceptanceOrderNumber) {
        return ((InvoiceAcceptanceGoodsMapper)this.baseMapper).findCrossByConditions(relationKaOrderCodes, acceptanceOrderNumber);
    }

    public void deleteByOrderNumbers(String tenantCode, List<String> orderNumbers) {
        if (CollectionUtils.isEmpty(orderNumbers)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(!CollectionUtils.isEmpty(orderNumbers), InvoiceAcceptanceGoodsEntity::getOrderNumber, orderNumbers)).remove();
    }

    public List<InvoiceAcceptanceGoodsVo> findByOrderNumberOrRelationKaOrderNumber(List<String> orderNumbers, List<String> relationKaOrderNumber, String tenantCode) {
        if (CollectionUtils.isEmpty(orderNumbers) && CollectionUtils.isEmpty(relationKaOrderNumber)) {
            return Lists.newArrayList();
        }
        return ((InvoiceAcceptanceGoodsMapper)this.baseMapper).findByOrderNumberOrRelationKaOrderNumber(orderNumbers, relationKaOrderNumber, tenantCode);
    }
}

