/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.mapper.InvoiceAcceptanceMapper;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceAcceptanceRepository
extends ServiceImpl<InvoiceAcceptanceMapper, InvoiceAcceptanceEntity> {
    public InvoiceAcceptanceEntity findById(String id) {
        return (InvoiceAcceptanceEntity)((Object)((InvoiceAcceptanceMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public InvoiceAcceptanceEntity findByDecomentCode(String code, String deliveryPartyCode) {
        if (StringUtils.isBlank((CharSequence)code) && StringUtils.isBlank((CharSequence)deliveryPartyCode)) {
            return null;
        }
        return (InvoiceAcceptanceEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(StringUtils.isNotBlank((CharSequence)code), InvoiceAcceptanceEntity::getKaOrderNumber, (Object)code)).eq(StringUtils.isNotBlank((CharSequence)deliveryPartyCode), InvoiceAcceptanceEntity::getDeliveryPartyCode, (Object)deliveryPartyCode)).one());
    }

    public List<InvoiceAcceptanceEntity> findByIds(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.isNotEmpty(ids), UuidEntity::getId, ids)).list();
    }

    public InvoiceAcceptanceEntity findByOrderNumber(String tenantCode, String orderNumber) {
        return (InvoiceAcceptanceEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(InvoiceAcceptanceEntity::getOrderNumber, (Object)orderNumber)).one());
    }

    public List<InvoiceAcceptanceEntity> findByOrderNumberList(String tenantCode, List<String> orderNumberList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(InvoiceAcceptanceEntity::getOrderNumber, orderNumberList)).list();
    }

    public InvoiceAcceptanceEntity findByKaOrderNumber(String tenantCode, String kaOrderNumber) {
        return (InvoiceAcceptanceEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(InvoiceAcceptanceEntity::getKaOrderNumber, (Object)kaOrderNumber)).one());
    }

    public void deleteByKaOrderNumber(String tenantCode, String kaOrderNumber) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(InvoiceAcceptanceEntity::getKaOrderNumber, (Object)kaOrderNumber)).remove();
    }

    public void deleteByKaOrderNumbers(String tenantCode, List<String> kaOrderNumbers) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(InvoiceAcceptanceEntity::getKaOrderNumber, kaOrderNumbers)).remove();
    }

    public void cancel(String statementCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InvoiceAcceptanceEntity::getStatementCode, (Object)statementCode)).set(InvoiceAcceptanceEntity::getStatementCode, null)).update();
    }

    public void match(List<String> orderNumbers, String statementCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(InvoiceAcceptanceEntity::getOrderNumber, orderNumbers)).set(InvoiceAcceptanceEntity::getStatementCode, (Object)statementCode)).update();
    }

    public Page<InvoiceAcceptanceVo> findAcceptanceByDirectCodes(Pageable pageable, String tenantCode, List<String> directCodes) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((InvoiceAcceptanceMapper)this.baseMapper).findAcceptanceByDirectCodes((Page<InvoiceAcceptanceVo>)page, tenantCode, directCodes);
    }

    public List<InvoiceAcceptanceVo> findAcceptanceOrderVo(String beginDate, String endDate, List<String> directCodes) {
        if (CollectionUtil.isNotEmpty(directCodes) && StringUtils.isNotEmpty((CharSequence)beginDate) && StringUtils.isNotEmpty((CharSequence)endDate)) {
            return ((InvoiceAcceptanceMapper)this.baseMapper).findAcceptanceOrderVo(beginDate, endDate, directCodes, TenantUtils.getTenantCode());
        }
        return Lists.newArrayList();
    }

    public void deleteByOrderNumbers(String tenantCode, List<String> orderNumbers) {
        if (CollectionUtils.isEmpty(orderNumbers)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(StringUtils.isNotBlank((CharSequence)tenantCode), TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(!CollectionUtils.isEmpty(orderNumbers), InvoiceAcceptanceEntity::getOrderNumber, orderNumbers)).remove();
    }
}

