/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGrabEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.mapper.KmsInvoiceAcceptanceGrabMapper;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class KmsInvoiceAcceptanceGrabRepository
extends ServiceImpl<KmsInvoiceAcceptanceGrabMapper, KmsInvoiceAcceptanceGrabEntity> {
    public List<KmsInvoiceAcceptanceGrabEntity> findByOrderNumbers(String tenantCode, List<String> orderNumbers) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(KmsInvoiceAcceptanceGrabEntity::getOrderNumber, orderNumbers)).list();
    }

    public void updateTransStatusById(String transStatus, String id, String transMsg) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidEntity::getId, (Object)id)).set(KmsInvoiceAcceptanceGrabEntity::getTransStatus, (Object)transStatus)).set(StringUtils.isNotBlank((CharSequence)transMsg), KmsInvoiceAcceptanceGrabEntity::getTransMsg, (Object)transMsg).update();
    }

    public Page<String> findAcceptanceOrderGrabPage(Pageable pageable, String tenantCode, List<String> transStatusList, String day) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((KmsInvoiceAcceptanceGrabMapper)this.baseMapper).findAcceptanceOrderGrabPage((Page<String>)page, tenantCode, transStatusList, day);
    }

    public void updateTransStatusByOrderNumber(String tenantCode, GrabTransStatus transStatus, String orderNumber) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || Objects.isNull(transStatus) || StringUtils.isBlank((CharSequence)orderNumber)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(KmsInvoiceAcceptanceGrabEntity::getOrderNumber, (Object)orderNumber)).set(KmsInvoiceAcceptanceGrabEntity::getTransStatus, (Object)transStatus.getDictCode())).update();
    }

    public void updateTransStatusByOrderNumberList(String tenantCode, GrabTransStatus transStatus, List<String> orderNumberList) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || Objects.isNull(transStatus) || CollectionUtil.isEmpty(orderNumberList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(KmsInvoiceAcceptanceGrabEntity::getOrderNumber, orderNumberList)).set(KmsInvoiceAcceptanceGrabEntity::getTransStatus, (Object)transStatus.getDictCode())).update();
    }
}

