/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceGoodsRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGoodsService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvoiceAcceptanceGoodsServiceImpl
implements InvoiceAcceptanceGoodsService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceGoodsServiceImpl.class);
    @Autowired(required=false)
    private InvoiceAcceptanceGoodsRepository invoiceAcceptanceGoodsRepository;

    @Override
    public List<InvoiceAcceptanceGoodsEntity> findByOrderNumber(String orderNumber) {
        if (StringUtils.isBlank((CharSequence)orderNumber)) {
            return null;
        }
        return this.invoiceAcceptanceGoodsRepository.findByOrderNumber(TenantUtils.getTenantCode(), orderNumber);
    }

    @Override
    @Transactional
    public void createBatch(List<InvoiceAcceptanceGoodsEntity> entities) {
        this.invoiceAcceptanceGoodsRepository.saveBatch(entities);
    }

    @Override
    @Transactional
    public void deleteByKaOrderNumber(String kaOrderNumber) {
        Validate.notEmpty((CharSequence)kaOrderNumber, (String)"\u5546\u8d85\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceAcceptanceGoodsRepository.deleteByKaOrderNumber(TenantUtils.getTenantCode(), kaOrderNumber);
    }

    @Override
    public List<InvoiceAcceptanceGoodsEntity> findInvoiceStatistics(List<Date> invoiceDates, List<String> goodsCodes, List<String> storeCodes, List<String> kaOrderNumbers) {
        return this.invoiceAcceptanceGoodsRepository.findInvoiceStatistics(invoiceDates, goodsCodes, storeCodes, kaOrderNumbers);
    }
}

