/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductDto;
import com.biz.crm.kms.business.direct.product.sdk.service.DirectProductVoService;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGoodsGrabEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.KmsInvoiceAcceptanceGrabEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.register.AcceptanceInvoiceTypeRegister;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.KmsInvoiceAcceptanceGoodsGrabRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.KmsInvoiceAcceptanceGrabRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGrabService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceOrderGrabsThreadService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.constant.AcceptanceOrderConstant;
import com.biz.crm.kms.business.invoice.acceptance.sdk.enums.AcceptanceStatus;
import com.biz.crm.kms.business.invoice.sdk.enums.AutoConvertsEnum;
import com.biz.crm.kms.business.invoice.sdk.enums.ConstantEnums;
import com.biz.crm.kms.business.invoice.sdk.enums.DirectEnum;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.service.RedisCrmService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceAcceptanceGrabServiceImpl
implements InvoiceAcceptanceGrabService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceGrabServiceImpl.class);
    @Autowired(required=false)
    private KmsInvoiceAcceptanceGrabRepository kmsInvoiceAcceptanceGrabRepository;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private DirectStoreVoService directStoreVoService;
    @Autowired(required=false)
    private DirectProductVoService directProductVoService;
    @Autowired(required=false)
    private RedisCrmService redisCrmService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private InvoiceAcceptanceOrderGrabsThreadService invoiceAcceptanceOrderGrabsThreadService;
    @Autowired(required=false)
    private InvoiceAcceptanceRepository invoiceAcceptanceRepository;
    @Autowired(required=false)
    private KmsInvoiceAcceptanceGoodsGrabRepository kmsInvoiceAcceptanceGoodsGrabRepository;
    @Autowired(required=false)
    private AcceptanceInvoiceTypeRegister acceptanceInvoiceTypeRegister;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DirectVoService directVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoNotConvertAcceptanceOrder() {
        log.info("=====>    \u9a8c\u6536\u5355\u672a\u8f6c\u6362\u5355\u636e\u81ea\u52a8\u8f6c\u6362 start   <=====");
        boolean lock = this.redisMutexService.tryLock("KMS:ACCEPTANCE:ORDER:AUTO_NOT_CONVERT:LOCK", TimeUnit.SECONDS, AcceptanceOrderConstant.ACCEPTANCE_ORDER_REDIS_TIME.intValue());
        if (!lock) {
            log.warn("\u9a8c\u6536\u5355\u6b63\u5728\u81ea\u52a8\u8f6c\u6362\u4e2d,\u672c\u6b21\u81ea\u52a8\u8f6c\u6362\u88ab\u5ffd\u7565!");
            log.info("=====>    \u9a8c\u6536\u5355\u672a\u8f6c\u6362\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
            return;
        }
        PageRequest pageable = PageRequest.of((int)1, (int)AcceptanceOrderConstant.ACCEPTANCE_ORDER_PAGE_SIZE);
        ArrayList<String> transStatusList = new ArrayList<String>();
        transStatusList.add(GrabTransStatus.NOT_TRANS.getDictCode());
        String day = this.getDays(AutoConvertsEnum.NOT_CONVERTS.getDictCode());
        HashSet currentOrderNumberSet = new HashSet(AcceptanceOrderConstant.ACCEPTANCE_ORDER_PAGE_SIZE);
        try {
            Page<String> orderNumberPage = this.kmsInvoiceAcceptanceGrabRepository.findAcceptanceOrderGrabPage((Pageable)pageable, TenantUtils.getTenantCode(), transStatusList, day);
            currentOrderNumberSet.addAll(orderNumberPage.getRecords());
            this.sendMqMessage(orderNumberPage.getRecords());
            while (orderNumberPage.hasNext() && AcceptanceOrderConstant.ACCEPTANCE_ORDER_LOOP_MAX >= pageable.getPageNumber()) {
                pageable = pageable.next();
                orderNumberPage = this.kmsInvoiceAcceptanceGrabRepository.findAcceptanceOrderGrabPage((Pageable)pageable, TenantUtils.getTenantCode(), transStatusList, day);
                currentOrderNumberSet.clear();
                currentOrderNumberSet.addAll(orderNumberPage.getRecords());
                this.sendMqMessage(orderNumberPage.getRecords());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            if (CollectionUtil.isNotEmpty(currentOrderNumberSet)) {
                this.redisCrmService.hdel("KMS:ACCEPTANCE:ORDER:CONVERT:LOCK:", currentOrderNumberSet.toArray());
            }
        }
        finally {
            this.redisMutexService.unlock("KMS:ACCEPTANCE:ORDER:AUTO_NOT_CONVERT:LOCK");
        }
        log.info("=====>    \u9a8c\u6536\u5355\u672a\u8f6c\u6362\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoFailConvertAcceptanceOrder() {
        log.info("=====>    \u9a8c\u6536\u5355\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362 start   <=====");
        boolean lock = this.redisMutexService.tryLock("KMS:ACCEPTANCE:ORDER:AUTO_FAIL_CONVERT:LOCK", TimeUnit.SECONDS, AcceptanceOrderConstant.ACCEPTANCE_ORDER_REDIS_TIME.intValue());
        if (!lock) {
            log.warn("\u9a8c\u6536\u5355\u6b63\u5728\u81ea\u52a8\u8f6c\u6362\u4e2d,\u672c\u6b21\u81ea\u52a8\u8f6c\u6362\u88ab\u5ffd\u7565!");
            log.info("=====>    \u9a8c\u6536\u5355\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
            return;
        }
        Pageable pageable = Pageable.ofSize((int)AcceptanceOrderConstant.ACCEPTANCE_ORDER_PAGE_SIZE);
        ArrayList<String> transStatusList = new ArrayList<String>();
        transStatusList.add(GrabTransStatus.TRANS_FAIL.getDictCode());
        String day = this.getDays(AutoConvertsEnum.FAIL_CONVERTS.getDictCode());
        HashSet currentOrderNumberSet = new HashSet(AcceptanceOrderConstant.ACCEPTANCE_ORDER_PAGE_SIZE);
        try {
            Page<String> orderNumberPage = this.kmsInvoiceAcceptanceGrabRepository.findAcceptanceOrderGrabPage(pageable, TenantUtils.getTenantCode(), transStatusList, day);
            currentOrderNumberSet.addAll(orderNumberPage.getRecords());
            this.sendMqMessage(orderNumberPage.getRecords());
            while (orderNumberPage.hasNext() && AcceptanceOrderConstant.ACCEPTANCE_ORDER_LOOP_MAX >= pageable.getPageNumber()) {
                pageable = pageable.next();
                orderNumberPage = this.kmsInvoiceAcceptanceGrabRepository.findAcceptanceOrderGrabPage(pageable, TenantUtils.getTenantCode(), transStatusList, day);
                currentOrderNumberSet.clear();
                currentOrderNumberSet.addAll(orderNumberPage.getRecords());
                this.sendMqMessage(orderNumberPage.getRecords());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            if (CollectionUtil.isNotEmpty(currentOrderNumberSet)) {
                this.redisCrmService.hdel("KMS:ACCEPTANCE:ORDER:CONVERT:LOCK:", currentOrderNumberSet.toArray());
            }
        }
        finally {
            this.redisMutexService.unlock("KMS:ACCEPTANCE:ORDER:AUTO_FAIL_CONVERT:LOCK");
        }
        log.info("=====>    \u9a8c\u6536\u5355\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
    }

    private void sendMqMessage(List<String> orderNumberList) {
        if (CollectionUtils.isEmpty(orderNumberList)) {
            return;
        }
        if (CollectionUtils.isEmpty(orderNumberList = orderNumberList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList()))) {
            log.error("\u9a8c\u6536\u5355\u539f\u59cb\u5355\u636e\u6709\u7a7a\u5355\u53f7[order_number]\u5b58\u5728!");
            return;
        }
        this.filterSwitchIngOrderNumberList(orderNumberList);
        if (CollectionUtil.isEmpty(orderNumberList)) {
            return;
        }
        MqMessageVo message = new MqMessageVo();
        message.setMsgBody(JSON.toJSONString(orderNumberList));
        message.setTopic("KMS_ACCEPTANCE_ORDER_TOPIC" + RocketMqUtil.mqEnvironment());
        message.setTag("KMS_ACCEPTANCE_ORDER_MESSAGE_TAG");
        this.rocketMqProducer.sendMqMsg(message);
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void manualSwitch(List<String> orderNumberList) {
        if (CollectionUtil.isEmpty(orderNumberList)) {
            log.warn("\u672a\u63a5\u6536\u5230\u9700\u8f6c\u6362\u9a8c\u6536\u5355\u53f7\uff01");
            return;
        }
        List<InvoiceAcceptanceEntity> orderList = this.buildOrder(orderNumberList);
        this.convertOrder(orderList);
    }

    private List<InvoiceAcceptanceEntity> buildOrder(List<String> orderNumberList) {
        log.info("--  \u7ec4\u88c5\u5355\u636e\u6b65\u9aa41  --");
        if (CollectionUtil.isEmpty(orderNumberList)) {
            return Collections.emptyList();
        }
        List<KmsInvoiceAcceptanceGrabEntity> entityGrabList = this.kmsInvoiceAcceptanceGrabRepository.findByOrderNumbers(TenantUtils.getTenantCode(), orderNumberList);
        if (CollectionUtil.isEmpty(entityGrabList)) {
            log.warn("\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01");
            return Collections.emptyList();
        }
        int defaultVersionNumber = 1;
        entityGrabList.forEach(entity -> {
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (Objects.isNull(entity.getVersionNumber())) {
                entity.setVersionNumber(defaultVersionNumber);
            }
        });
        List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityGrabList, KmsInvoiceAcceptanceGrabEntity.class, InvoiceAcceptanceEntity.class, HashSet.class, ArrayList.class, new String[0]);
        Map entityMap = entityList.stream().collect(Collectors.toMap(InvoiceAcceptanceEntity::getOrderNumber, Function.identity(), (a, b) -> a.getVersionNumber() > b.getVersionNumber() ? a : b));
        ArrayList<InvoiceAcceptanceEntity> convertData = new ArrayList<InvoiceAcceptanceEntity>(entityMap.values());
        List<KmsInvoiceAcceptanceGoodsGrabEntity> goodsGrabEntities = this.kmsInvoiceAcceptanceGoodsGrabRepository.findByOrderNumbers(orderNumberList, TenantUtils.getTenantCode());
        if (CollectionUtil.isNotEmpty(goodsGrabEntities)) {
            List goodsEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(goodsGrabEntities, KmsInvoiceAcceptanceGoodsGrabEntity.class, InvoiceAcceptanceGoodsEntity.class, HashSet.class, ArrayList.class, new String[0]);
            goodsEntities.forEach(entity -> {
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                if (Objects.isNull(entity.getVersionNumber())) {
                    entity.setVersionNumber(defaultVersionNumber);
                }
            });
            Map<String, List<InvoiceAcceptanceGoodsEntity>> goodsMap = goodsEntities.stream().collect(Collectors.groupingBy(InvoiceAcceptanceGoodsEntity::getOrderNumber));
            convertData.forEach(entity -> {
                List goodsEntityList = (List)goodsMap.get(entity.getOrderNumber());
                if (CollectionUtil.isNotEmpty((Collection)goodsEntityList)) {
                    List<InvoiceAcceptanceGoodsEntity> goodsInfo = goodsEntityList.stream().filter(goods -> entity.getVersionNumber().compareTo(goods.getVersionNumber()) == 0).collect(Collectors.toList());
                    entity.setGoodsList(goodsInfo);
                }
            });
        }
        return convertData;
    }

    @Override
    public void convertOrder(List<InvoiceAcceptanceEntity> entityList) {
        log.info("--  \u5355\u636e\u8f6c\u6362\u6240\u9700\u6570\u636e\u67e5\u8be2  --");
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        if (CollectionUtils.isEmpty(entityList = entityList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getOrderNumber())).collect(Collectors.toList()))) {
            return;
        }
        HashSet directCodeSet = Sets.newHashSet();
        ArrayList orderNumberList = Lists.newArrayList();
        HashSet kaStoreCodes = Sets.newHashSet();
        HashSet kaGoodsCodes = Sets.newHashSet();
        entityList.forEach(entity -> {
            Set goodsCodeSet;
            entity.setOrderStatus(AcceptanceStatus.S101.getDictCode());
            if (StringUtils.isNotEmpty((CharSequence)entity.getDirectCode())) {
                directCodeSet.add(entity.getDirectCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getKaStoreCode())) {
                if (DirectEnum.GAOXIN_TJ.getDictCode().equals(entity.getDirectCode()) || DirectEnum.GAOXIN_BJ.getDictCode().equals(entity.getDirectCode())) {
                    entity.setAreaCode(entity.getKaStoreCode().substring(0, 1));
                    String kaStoreCode = entity.getKaStoreCode().substring(1, 4);
                    Integer aa = new Integer(kaStoreCode);
                    String bb = String.valueOf(aa);
                    entity.setKaStoreCode(bb);
                    kaStoreCodes.add(bb);
                } else {
                    kaStoreCodes.add(entity.getKaStoreCode());
                }
            }
            orderNumberList.add(entity.getOrderNumber());
            if (CollectionUtil.isNotEmpty(entity.getGoodsList()) && CollectionUtil.isNotEmpty(goodsCodeSet = entity.getGoodsList().stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getKaGoodsCode())).map(InvoiceAcceptanceGoodsEntity::getKaGoodsCode).collect(Collectors.toSet()))) {
                kaGoodsCodes.addAll(goodsCodeSet);
            }
        });
        entityList = this.updateOldDataToNewData(orderNumberList, entityList);
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        List directVos = this.directVoService.findByDirectCodes(directCodeSet.stream().collect(Collectors.toList()));
        HashMap directMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)directVos)) {
            directMap.putAll(directVos.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)k.getBusinessFormatCode())).collect(Collectors.groupingBy(DirectVo::getDirectCode)));
        }
        Map<String, List<DirectStoreVo>> directStoreMap = this.buildStoreInfo(directCodeSet, kaStoreCodes);
        HashSet deliveryPartyCodeSet = Sets.newHashSet();
        if (CollectionUtil.isNotEmpty(directStoreMap)) {
            directStoreMap.values().stream().filter(CollUtil::isNotEmpty).forEach(directStoreVoList -> directStoreVoList.forEach(entity -> {
                deliveryPartyCodeSet.add(entity.getTerminalCode());
                if (StringUtils.isNotBlank((CharSequence)entity.getRetailerTerminalCode())) {
                    deliveryPartyCodeSet.add(entity.getRetailerTerminalCode());
                }
            }));
        }
        Map<String, List<DirectProductVo>> directProductMap = this.buildProductInfo(directCodeSet, deliveryPartyCodeSet, kaGoodsCodes);
        List entityGroupList = Lists.partition(entityList, (int)ConstantEnums.THREAD_SIZE.getValue());
        entityGroupList.stream().filter(CollUtil::isNotEmpty).forEach(asyncList -> this.invoiceAcceptanceOrderGrabsThreadService.saveAcceptanceOrderData((List<InvoiceAcceptanceEntity>)asyncList, directMap, directStoreMap, directProductMap));
    }

    private Map<String, List<DirectStoreVo>> buildStoreInfo(Set<String> directCodeSet, Set<String> kaStoreCodes) {
        HashMap directStoreMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(kaStoreCodes) || CollectionUtil.isEmpty(directCodeSet)) {
            return directStoreMap;
        }
        DirectStoreConditionDto conditionDto = new DirectStoreConditionDto();
        conditionDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        conditionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        conditionDto.setSupermarketStoreCodes(kaStoreCodes);
        conditionDto.setDirectCodes(directCodeSet);
        List directStoreList = this.directStoreVoService.findByDirectStoreConditionDto(conditionDto);
        if (CollectionUtil.isNotEmpty((Collection)directStoreList)) {
            directStoreMap.putAll(directStoreList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDirectCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getSupermarketStoreCode())).collect(Collectors.groupingBy(k -> k.getDirectCode() + "_" + k.getSupermarketStoreCode())));
        }
        return directStoreMap;
    }

    private Map<String, List<DirectProductVo>> buildProductInfo(Set<String> directCodeSet, Set<String> deliveryPartyCodeSet, Set<String> kaGoodsCodes) {
        HashMap directProductMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(directCodeSet) || CollectionUtil.isEmpty(deliveryPartyCodeSet) || CollectionUtil.isEmpty(kaGoodsCodes)) {
            return directProductMap;
        }
        List kaProductCodeGroupList = Lists.partition((List)Lists.newArrayList(kaGoodsCodes), (int)ConstantEnums.PRODUCT_SIZE.getValue());
        DirectProductDto directProductDto = new DirectProductDto();
        directProductDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        directProductDto.setTenantCode(TenantUtils.getTenantCode());
        directProductDto.setOnShelfStatus(BooleanEnum.TRUE.getCapital());
        directProductDto.setDirectCodes(new ArrayList<String>(directCodeSet));
        directProductDto.setDeliveryPartyCodes(new ArrayList<String>(deliveryPartyCodeSet));
        directProductDto.setOrderType(this.acceptanceInvoiceTypeRegister.type());
        kaProductCodeGroupList.forEach(kaProductCodeList -> {
            directProductDto.setKaProductCodes(kaProductCodeList);
            List productList = this.directProductVoService.findByDirectProductDto(directProductDto);
            if (CollectionUtil.isNotEmpty((Collection)productList)) {
                directProductMap.putAll(productList.stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getOnShelfStatus())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getDirectCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getDeliveryPartyCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getKaProductCode())).collect(Collectors.groupingBy(k -> k.getDirectCode() + "_" + k.getDeliveryPartyCode() + "_" + k.getKaProductCode())));
            }
        });
        return directProductMap;
    }

    private List<InvoiceAcceptanceEntity> updateOldDataToNewData(List<String> orderNumberList, List<InvoiceAcceptanceEntity> entityList) {
        if (CollectionUtil.isEmpty(orderNumberList) || CollectionUtil.isEmpty(entityList)) {
            return entityList;
        }
        List<InvoiceAcceptanceEntity> oldEntityList = this.invoiceAcceptanceRepository.findByOrderNumberList(TenantUtils.getTenantCode(), orderNumberList);
        Map<String, InvoiceAcceptanceEntity> oldMap = oldEntityList.stream().collect(Collectors.toMap(InvoiceAcceptanceEntity::getOrderNumber, v -> v, (oldValue, newValue) -> newValue));
        entityList.forEach(entity -> {
            InvoiceAcceptanceEntity oldEntity = (InvoiceAcceptanceEntity)((Object)((Object)oldMap.get(entity.getOrderNumber())));
            if (oldEntity != null) {
                entity.setId(oldEntity.getId());
                entity.setOrderStatus(oldEntity.getOrderStatus());
            } else {
                entity.setId(null);
            }
        });
        return entityList;
    }

    @Override
    public void filterSwitchIngOrderNumberList(List<String> orderNumberList) {
        if (CollectionUtil.isEmpty(orderNumberList)) {
            return;
        }
        List updateList = this.redisCrmService.hmget("KMS:ACCEPTANCE:ORDER:CONVERT:LOCK:", new HashSet<String>(orderNumberList));
        if (CollectionUtil.isNotEmpty((Collection)updateList)) {
            orderNumberList.removeAll(updateList.stream().filter(Objects::nonNull).filter(k -> StringUtils.isNotEmpty((CharSequence)k.toString())).map(Object::toString).collect(Collectors.toList()));
        }
        Map<String, String> redisMap = orderNumberList.stream().collect(Collectors.toMap(key -> key, key -> key, (oldValue, newValue) -> newValue));
        this.redisCrmService.hmset("KMS:ACCEPTANCE:ORDER:CONVERT:LOCK:", redisMap, TimeUnit.SECONDS, (long)AcceptanceOrderConstant.ACCEPTANCE_ORDER_REDIS_TIME.intValue());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<KmsInvoiceAcceptanceGrabEntity> kmsInvoiceAcceptanceGrabEntities) {
        if (CollectionUtils.isEmpty(kmsInvoiceAcceptanceGrabEntities)) {
            return;
        }
        kmsInvoiceAcceptanceGrabEntities.forEach(aa -> {
            aa.setTenantCode(TenantUtils.getTenantCode());
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setInvoicesSource("\u624b\u52a8\u5bfc\u5165");
            this.kmsInvoiceAcceptanceGrabRepository.save(aa);
            this.kmsInvoiceAcceptanceGoodsGrabRepository.saveBatch(aa.getGoodsList());
        });
    }

    private String getDays(String type) {
        Map fomatMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"kms_auto_converts"}));
        List vos = (List)fomatMap.get("kms_auto_converts");
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(type)).map(DictDataVo::getDictValue).findFirst();
        int past = Integer.parseInt(first.orElse(""));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.get(5) - past);
        String day = sdf.format(calendar.getTime());
        return day;
    }
}

