/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGoodsService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceOrderGoodsImportsService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceGoodsDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceOrderGoodsLogEventDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.event.InvoiceAcceptanceOrderGoodsLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceAcceptanceOrderGoodsImportsServiceImpl
implements InvoiceAcceptanceOrderGoodsImportsService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceOrderGoodsImportsServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private InvoiceAcceptanceGoodsService invoiceAcceptanceGoodsService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importsSave(List<InvoiceAcceptanceGoodsEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(aa -> {
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
        });
        this.invoiceAcceptanceGoodsService.createBatch(list);
        Collection invoiceAcceptanceGoodsDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list, InvoiceAcceptanceGoodsEntity.class, InvoiceAcceptanceGoodsDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        invoiceAcceptanceGoodsDtos.forEach(dto -> {
            InvoiceAcceptanceOrderGoodsLogEventDto logEventDto = new InvoiceAcceptanceOrderGoodsLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = InvoiceAcceptanceOrderGoodsLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InvoiceAcceptanceOrderGoodsLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }
}

